/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.interval;

import java.util.HashMap;
import net.imagej.axis.AxisType;
import net.imagej.axis.TypedAxis;
import net.imagej.interval.TypedRealInterval;
import net.imagej.space.CombinedSpace;
import net.imglib2.RealPositionable;

public class CombinedRealInterval<A extends TypedAxis, S extends TypedRealInterval<A>>
extends CombinedSpace<A, S>
implements TypedRealInterval<A> {
    private final HashMap<AxisType, MinMax> minMax = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        CombinedRealInterval combinedRealInterval = this;
        synchronized (combinedRealInterval) {
            super.update();
            this.minMax.clear();
            for (TypedRealInterval interval : this) {
                for (int d = 0; d < interval.numDimensions(); ++d) {
                    AxisType axisType = ((TypedAxis)interval.axis(d)).type();
                    if (!this.minMax.containsKey(axisType)) {
                        this.minMax.put(axisType, new MinMax());
                    }
                    MinMax mm = this.minMax.get(axisType);
                    mm.expand(interval.realMin(d), interval.realMax(d));
                }
            }
        }
    }

    public double realMin(int d) {
        return this.minMax().get(this.axis(d).type()).min();
    }

    public void realMin(double[] min) {
        for (int i = 0; i < min.length; ++i) {
            min[i] = this.realMin(i);
        }
    }

    public void realMin(RealPositionable min) {
        for (int i = 0; i < min.numDimensions(); ++i) {
            min.setPosition(this.realMin(i), i);
        }
    }

    public double realMax(int d) {
        return this.minMax().get(this.axis(d).type()).max();
    }

    public void realMax(double[] max) {
        for (int i = 0; i < max.length; ++i) {
            max[i] = this.realMax(i);
        }
    }

    public void realMax(RealPositionable max) {
        for (int i = 0; i < max.numDimensions(); ++i) {
            max.setPosition(this.realMax(i), i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<AxisType, MinMax> minMax() {
        CombinedRealInterval combinedRealInterval = this;
        synchronized (combinedRealInterval) {
            return this.minMax;
        }
    }

    protected class MinMax {
        private double minMin = Double.POSITIVE_INFINITY;
        private double maxMax = Double.NEGATIVE_INFINITY;

        protected MinMax() {
        }

        public void expand(double min, double max) {
            if (min < this.minMin) {
                this.minMin = min;
            }
            if (max > this.maxMax) {
                this.maxMax = max;
            }
        }

        public double min() {
            return this.minMin;
        }

        public double max() {
            return this.maxMax;
        }
    }
}

