/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.imagej.overlay.AbstractROIOverlay;
import net.imagej.overlay.Overlay;
import net.imglib2.roi.CompositeRegionOfInterest;
import org.scijava.Context;

public class CompositeOverlay
extends AbstractROIOverlay<CompositeRegionOfInterest> {
    private List<Overlay> overlays = new ArrayList<Overlay>();
    private List<Operation> operations = new ArrayList<Operation>();

    public CompositeOverlay() {
        super(new CompositeRegionOfInterest(2));
    }

    public CompositeOverlay(Context context) {
        this(context, 2);
    }

    public CompositeOverlay(Context context, int numDimensions) {
        super(context, new CompositeRegionOfInterest(numDimensions));
    }

    @Override
    public void move(double[] deltas) {
        for (Overlay o : this.overlays) {
            o.move(deltas);
        }
        this.recalcRegionOfInterest();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.overlays = (List)in.readObject();
        this.operations = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.overlays);
        out.writeObject(this.operations);
    }

    public void startWith(Overlay o) {
        this.overlays.clear();
        this.operations.clear();
        this.overlays.add(o);
        this.operations.add(Operation.OR);
        CompositeRegionOfInterest newRoi = new CompositeRegionOfInterest(o.getRegionOfInterest());
        this.setRegionOfInterest(newRoi);
    }

    public void and(Overlay o) {
        if (this.overlays.size() == 0) {
            this.startWith(o);
            return;
        }
        this.overlays.add(o);
        this.operations.add(Operation.AND);
        ((CompositeRegionOfInterest)this.getRegionOfInterest()).and(o.getRegionOfInterest());
    }

    public void or(Overlay o) {
        if (this.overlays.size() == 0) {
            this.startWith(o);
            return;
        }
        this.overlays.add(o);
        this.operations.add(Operation.OR);
        ((CompositeRegionOfInterest)this.getRegionOfInterest()).or(o.getRegionOfInterest());
    }

    public void xor(Overlay o) {
        if (this.overlays.size() == 0) {
            this.startWith(o);
            return;
        }
        this.overlays.add(o);
        this.operations.add(Operation.XOR);
        ((CompositeRegionOfInterest)this.getRegionOfInterest()).xor(o.getRegionOfInterest());
    }

    public void not(Overlay o) {
        if (this.overlays.size() == 0) {
            throw new IllegalArgumentException("CompositeOverlay cannot start with a NOT operation");
        }
        this.overlays.add(o);
        this.operations.add(Operation.NOT);
        ((CompositeRegionOfInterest)this.getRegionOfInterest()).not(o.getRegionOfInterest());
    }

    public void remove(Overlay o) {
        int i = 0;
        while (i < this.overlays.size()) {
            Overlay ovr = this.overlays.get(i);
            if (ovr == o) {
                this.overlays.remove(i);
                this.operations.remove(i);
                continue;
            }
            ++i;
        }
        if (this.overlays.size() == 0) {
            throw new IllegalArgumentException("Modified CompositeOverlay now consists of no overlays");
        }
        if (this.operations.get(0) == Operation.NOT) {
            throw new IllegalArgumentException("Modified CompositeOverlay now starts with a NOT operation");
        }
        this.recalcRegionOfInterest();
    }

    public void doOperation(Operation op, Overlay o) {
        switch (op) {
            case AND: {
                this.and(o);
                break;
            }
            case OR: {
                this.or(o);
                break;
            }
            case XOR: {
                this.xor(o);
                break;
            }
            case NOT: {
                this.not(o);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation: " + (Object)((Object)op));
            }
        }
    }

    public List<Overlay> getSubcomponents() {
        return Collections.unmodifiableList(this.overlays);
    }

    private void recalcRegionOfInterest() {
        CompositeRegionOfInterest newRoi = new CompositeRegionOfInterest(this.overlays.get(0).getRegionOfInterest());
        block6: for (int i = 1; i < this.overlays.size(); ++i) {
            Overlay o = this.overlays.get(i);
            Operation op = this.operations.get(i);
            switch (op) {
                case AND: {
                    newRoi.and(o.getRegionOfInterest());
                    continue block6;
                }
                case OR: {
                    newRoi.or(o.getRegionOfInterest());
                    continue block6;
                }
                case XOR: {
                    newRoi.xor(o.getRegionOfInterest());
                    continue block6;
                }
                case NOT: {
                    newRoi.not(o.getRegionOfInterest());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation " + (Object)((Object)op));
                }
            }
        }
        this.setRegionOfInterest(newRoi);
    }

    public static enum Operation {
        AND,
        OR,
        XOR,
        NOT;

    }
}

