/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.IOException;
import org.apposed.appose.Builder;
import org.apposed.appose.BuilderFactory;
import org.apposed.appose.Environment;
import org.apposed.appose.builder.BaseBuilder;
import org.apposed.appose.builder.Builders;

public final class DynamicBuilder
extends BaseBuilder<DynamicBuilder> {
    private final String source;
    private String scheme;
    private String builderName;

    public DynamicBuilder(String source) {
        this.source = source;
    }

    @Override
    public DynamicBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public DynamicBuilder builder(String builderName) {
        this.builderName = builderName;
        return this;
    }

    @Override
    public String name() {
        return "dynamic";
    }

    @Override
    public Environment build() throws IOException {
        Builder<?> delegate = this.createBuilder(this.builderName, this.source, this.scheme);
        this.copyConfigToDelegate(delegate);
        return delegate.build();
    }

    @Override
    public Environment rebuild() throws IOException {
        Builder<?> delegate = this.createBuilder(this.builderName, this.source, this.scheme);
        this.copyConfigToDelegate(delegate);
        return delegate.rebuild();
    }

    private void copyConfigToDelegate(Builder<?> delegate) {
        delegate.env(this.envVars);
        if (this.envName != null) {
            delegate.name(this.envName);
        }
        if (this.envDir != null) {
            delegate.base(this.envDir);
        }
        delegate.channels(this.channels);
        this.progressSubscribers.forEach(delegate::subscribeProgress);
        this.outputSubscribers.forEach(delegate::subscribeOutput);
        this.errorSubscribers.forEach(delegate::subscribeError);
    }

    private Builder<?> createBuilder(String name, String source, String scheme) throws IOException {
        if (name != null) {
            BuilderFactory factory = Builders.findFactoryByName(name);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown builder: " + name);
            }
            return factory.createBuilder(source, scheme);
        }
        if (scheme != null) {
            BuilderFactory factory = Builders.findFactoryByScheme(scheme);
            if (factory == null) {
                throw new IllegalArgumentException("No builder supports scheme: " + scheme);
            }
            return factory.createBuilder(source, scheme);
        }
        if (source != null) {
            BuilderFactory factory = Builders.findFactoryBySource(source);
            if (factory == null) {
                throw new IllegalArgumentException("No builder supports source: " + source);
            }
            return factory.createBuilder(source);
        }
        throw new IllegalArgumentException("At least one of builder name, source, and scheme must be non-null");
    }
}

