/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BHInternalNode;
import org.scijava.java3d.BoundingBox;

abstract class BHNode {
    static final byte BH_TYPE_INTERNAL = 1;
    static final byte BH_TYPE_LEAF = 2;
    static final int NUMBER_OF_PLANES = 6;
    static final boolean debug = false;
    static final boolean debug2 = false;
    BHNode parent;
    byte nodeType;
    BoundingBox bHull = null;
    boolean mark;

    BHNode() {
        this.parent = null;
        this.mark = false;
    }

    BHNode(BHNode parent) {
        this.parent = parent;
        this.mark = false;
    }

    BHNode(BHNode parent, BoundingBox bHull) {
        this.parent = parent;
        this.mark = false;
        this.bHull = bHull;
    }

    BHNode getParent() {
        return this.parent;
    }

    abstract void computeBoundingHull();

    abstract void updateMarkedBoundingHull();

    abstract void destroyTree(BHNode[] var1, int[] var2);

    void setParent(BHNode node) {
        this.parent = node;
    }

    BoundingBox getBoundingHull() {
        return this.bHull;
    }

    void setBoundingHull(BoundingBox bHull) {
        this.bHull = bHull;
    }

    void combineBHull(BHNode node1, BHNode node2) {
        BoundingBox bHull1 = null;
        BoundingBox bHull2 = null;
        bHull1 = node1.getBoundingHull();
        bHull2 = node2.getBoundingHull();
        if (this.bHull == null) {
            this.bHull = new BoundingBox(bHull1);
        } else {
            this.bHull.set(bHull1);
        }
        this.bHull.combine(bHull2);
    }

    boolean isInside(BoundingBox bHull) {
        if (bHull == null) {
            return false;
        }
        if (this.bHull.isEmpty() || bHull.isEmpty()) {
            return false;
        }
        return !(this.bHull.upper.x < bHull.upper.x || this.bHull.upper.y < bHull.upper.y || this.bHull.upper.z < bHull.upper.z || this.bHull.lower.x > bHull.lower.x || this.bHull.lower.y > bHull.lower.y) && !(this.bHull.lower.z > bHull.lower.z);
    }

    BHNode findNode(BHNode node) {
        BHNode fNode = null;
        if (this.nodeType == 2) {
            if (this == node) {
                return this;
            }
        } else {
            if (((BHInternalNode)this).rChild.isInside(node.bHull) && (fNode = ((BHInternalNode)this).rChild.findNode(node)) != null) {
                return fNode;
            }
            if (((BHInternalNode)this).lChild.isInside(node.bHull)) {
                return ((BHInternalNode)this).lChild.findNode(node);
            }
        }
        return null;
    }

    void deleteFromParent() {
        BHInternalNode parent = (BHInternalNode)this.parent;
        if (parent != null) {
            if (parent.rChild == this) {
                parent.rChild = null;
            } else if (parent.lChild == this) {
                parent.lChild = null;
            }
        }
    }

    BHNode deleteAndUpdateMarkedNodes() {
        if (this.mark) {
            if (this.nodeType == 2) {
                this.deleteFromParent();
                return null;
            }
            if (((BHInternalNode)this).rChild != null) {
                ((BHInternalNode)this).rChild = ((BHInternalNode)this).rChild.deleteAndUpdateMarkedNodes();
            }
            if (((BHInternalNode)this).lChild != null) {
                ((BHInternalNode)this).lChild = ((BHInternalNode)this).lChild.deleteAndUpdateMarkedNodes();
            }
            if (((BHInternalNode)this).rChild == null && ((BHInternalNode)this).lChild == null) {
                this.deleteFromParent();
                return null;
            }
            if (((BHInternalNode)this).rChild == null) {
                BHNode leftChild = ((BHInternalNode)this).lChild;
                leftChild.parent = this.parent;
                this.deleteFromParent();
                return leftChild;
            }
            if (((BHInternalNode)this).lChild == null) {
                BHNode rightChild = ((BHInternalNode)this).rChild;
                rightChild.parent = this.parent;
                this.deleteFromParent();
                return rightChild;
            }
            this.combineBHull(((BHInternalNode)this).rChild, ((BHInternalNode)this).lChild);
            ((BHInternalNode)this).rChild.parent = this;
            ((BHInternalNode)this).lChild.parent = this;
            this.mark = false;
            return this;
        }
        return this;
    }

    int countNumberOfInternals() {
        if (this.nodeType == 2) {
            return 0;
        }
        return ((BHInternalNode)this).rChild.countNumberOfInternals() + ((BHInternalNode)this).lChild.countNumberOfInternals() + 1;
    }

    int countNumberOfLeaves() {
        if (this.nodeType == 2) {
            return 1;
        }
        return ((BHInternalNode)this).rChild.countNumberOfLeaves() + ((BHInternalNode)this).lChild.countNumberOfLeaves();
    }

    int computeMaxDepth(int currentDepth) {
        int leftDepth;
        if (this.nodeType == 2) {
            return currentDepth;
        }
        int rightDepth = ((BHInternalNode)this).rChild.computeMaxDepth(currentDepth + 1);
        if (rightDepth > (leftDepth = ((BHInternalNode)this).lChild.computeMaxDepth(currentDepth + 1))) {
            return rightDepth;
        }
        return leftDepth;
    }

    float computeAverageLeafDepth(int numberOfLeaves, int currentDepth) {
        int sumOfDepths = this.computeSumOfDepths(0);
        return (float)sumOfDepths / (float)numberOfLeaves;
    }

    int computeSumOfDepths(int currentDepth) {
        if (this.nodeType == 2) {
            return currentDepth;
        }
        return ((BHInternalNode)this).rChild.computeSumOfDepths(currentDepth + 1) + ((BHInternalNode)this).lChild.computeSumOfDepths(currentDepth + 1);
    }
}

