/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasFormat;
import io.scif.services.FormatService;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;

public abstract class AbstractHasFormat
extends AbstractSCIFIOPlugin
implements HasFormat {
    private static final String NO_FORMAT = "Format for this metadata could not be determined.";
    @Parameter
    private FormatService formatService;

    @Override
    public Format getFormat() {
        return this.formatService.getFormatFromComponent(this.getClass());
    }

    @Override
    public String getFormatName() {
        Format format = this.getFormat();
        if (format == null) {
            return NO_FORMAT;
        }
        return format.getFormatName();
    }

    protected BrowsableLocation asBrowsableLocation(Location loc) throws FormatException {
        if (loc instanceof BrowsableLocation) {
            return (BrowsableLocation)loc;
        }
        throw new FormatException("The format: '" + this.getFormatName() + "' requires a browsable Location!");
    }

    protected BrowsableLocation asBrowsableLocation(DataHandle<Location> handle) throws FormatException {
        return this.asBrowsableLocation((Location)handle.get());
    }
}

