/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.DataPlane;
import io.scif.ImageMetadata;
import io.scif.Plane;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;

public abstract class AbstractPlane<T, P extends DataPlane<T>>
implements DataPlane<T> {
    private T data = null;
    private ColorTable lut = null;
    private ImageMetadata meta = null;
    private Interval bounds;

    public AbstractPlane() {
    }

    public AbstractPlane(ImageMetadata meta, Interval bounds) {
        this.populate(meta, bounds);
    }

    @Override
    public void setData(T data) {
        this.data = data;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public void setColorTable(ColorTable lut) {
        this.lut = lut;
    }

    @Override
    public ColorTable getColorTable() {
        return this.lut;
    }

    @Override
    public ImageMetadata getImageMetadata() {
        return this.meta;
    }

    public P populate(Plane p) {
        return (P)this.populate(p.getImageMetadata(), p.getBounds());
    }

    public P populate(DataPlane<T> plane) {
        return this.populate(plane.getImageMetadata(), plane.getData(), plane.getBounds());
    }

    public P populate(ImageMetadata meta, Interval bounds) {
        return this.populate(meta, null, bounds);
    }

    public P populate(T data, Interval bounds) {
        return this.populate(null, data, bounds);
    }

    public P populate(ImageMetadata meta, T data, Interval bounds) {
        this.setImageMetadata(meta);
        if (data == null) {
            data = this.blankPlane(bounds);
        }
        this.setData(data);
        this.setBounds(bounds);
        AbstractPlane pl = this;
        return (P)pl;
    }

    @Override
    public void setImageMetadata(ImageMetadata meta) {
        this.meta = meta;
    }

    @Override
    public Interval getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Interval bounds) {
        this.bounds = bounds;
    }

    protected abstract T blankPlane(Interval var1);
}

