/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.qt;

import io.scif.FormatException;
import io.scif.MissingLibraryException;
import io.scif.formats.qt.QTJavaService;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ReflectException;
import org.scijava.util.ReflectedUniverse;

@Plugin(type=Service.class)
public class DefaultQTJavaService
extends AbstractService
implements QTJavaService {
    private static final String NO_QT_MSG = "QuickTime for Java is required to read some QuickTime files. Please install QuickTime for Java from http://www.apple.com/quicktime/";
    private static final String JVM_64BIT_MSG = "QuickTime for Java is not supported with a 64-bit JVM. Please invoke the 32-bit JVM (-d32) to utilize QTJava functionality.";
    private static final String EXPIRED_QT_MSG = "Your version of QuickTime for Java has expired. Please reinstall QuickTime for Java from http://www.apple.com/quicktime/";
    private static final boolean MAC_OS_X = System.getProperty("os.name").equals("Mac OS X");
    private static ClassLoader loader;
    @Parameter
    private LogService log;
    private boolean initialized = false;
    private boolean noQT = false;
    private boolean jvm64Bit = false;
    private boolean expiredQT = false;
    private ReflectedUniverse r;

    @Override
    public boolean canDoQT() {
        if (!this.initialized) {
            this.initQTJava();
        }
        return !this.noQT;
    }

    @Override
    public boolean isJVM64Bit() {
        if (!this.initialized) {
            this.initQTJava();
        }
        return this.jvm64Bit;
    }

    @Override
    public boolean isQTExpired() {
        if (!this.initialized) {
            this.initQTJava();
        }
        return this.expiredQT;
    }

    @Override
    public String getQTVersion() {
        if (this.isJVM64Bit()) {
            return "Not available";
        }
        if (this.isQTExpired()) {
            return "Expired";
        }
        if (!this.canDoQT()) {
            return "Missing";
        }
        try {
            String qtMajor = this.r.exec("QTSession.getMajorVersion()").toString();
            String qtMinor = this.r.exec("QTSession.getMinorVersion()").toString();
            return qtMajor + "." + qtMinor;
        }
        catch (Throwable t) {
            this.log.debug((Object)"Could not retrieve QuickTime for Java version", t);
            return "Error";
        }
    }

    @Override
    public ReflectedUniverse getUniverse() {
        if (!this.initialized) {
            this.initQTJava();
        }
        return this.r;
    }

    @Override
    public Dimension getPictDimensions(byte[] bytes) throws FormatException, ReflectException {
        this.checkQTLibrary();
        try {
            this.r.exec("QTSession.open()");
            this.r.setVar("bytes", (Object)bytes);
            this.r.exec("pict = new Pict(bytes)");
            this.r.exec("box = pict.getPictFrame()");
            int width = (Integer)this.r.exec("box.getWidth()");
            int height = (Integer)this.r.exec("box.getHeight()");
            this.r.exec("QTSession.close()");
            return new Dimension(width, height);
        }
        catch (ReflectException e) {
            this.r.exec("QTSession.close()");
            throw new FormatException("PICT height determination failed", e);
        }
    }

    @Override
    public synchronized Image pictToImage(byte[] bytes) throws FormatException {
        this.checkQTLibrary();
        try {
            this.r.exec("QTSession.open()");
            this.r.setVar("bytes", (Object)bytes);
            this.r.exec("pict = new Pict(bytes)");
            this.r.exec("box = pict.getPictFrame()");
            int width = (Integer)this.r.exec("box.getWidth()");
            int height = (Integer)this.r.exec("box.getHeight()");
            this.r.exec("g = new QDGraphics(box)");
            this.r.exec("pict.draw(g, box)");
            this.r.exec("pixMap = g.getPixMap()");
            this.r.exec("rei = pixMap.getPixelData()");
            int rowBytes = (Integer)this.r.exec("pixMap.getRowBytes()");
            int intsPerRow = rowBytes / 4;
            int pixLen = intsPerRow * height;
            this.r.setVar("pixLen", pixLen);
            int[] pixels = new int[pixLen];
            this.r.setVar("pixels", (Object)pixels);
            this.r.setVar("zero", (Object)new Integer(0));
            this.r.exec("rei.copyToArray(zero, pixels, zero, pixLen)");
            int bitsPerSample = 32;
            int redMask = 0xFF0000;
            int greenMask = 65280;
            int blueMask = 255;
            boolean alphaMask = false;
            DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
            this.r.exec("QTSession.close()");
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, (ColorModel)colorModel, pixels, 0, intsPerRow));
        }
        catch (ReflectException e) {
            try {
                this.r.exec("QTSession.close()");
            }
            catch (ReflectException exc) {
                this.log.info((Object)"Could not close QuickTime session", (Throwable)exc);
            }
            throw new FormatException("PICT extraction failed", e);
        }
    }

    @Override
    public void checkQTLibrary() throws MissingLibraryException {
        if (this.isJVM64Bit()) {
            throw new MissingLibraryException(JVM_64BIT_MSG);
        }
        if (this.isQTExpired()) {
            throw new MissingLibraryException(EXPIRED_QT_MSG);
        }
        if (!this.canDoQT()) {
            throw new MissingLibraryException(NO_QT_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQTJava() {
        if (this.initialized) {
            return;
        }
        String arch = System.getProperty("os.arch");
        if (arch != null && arch.contains("64")) {
            this.noQT = true;
            this.jvm64Bit = true;
            this.initialized = true;
            return;
        }
        boolean needClose = false;
        if (loader == null) {
            loader = this.constructLoader();
        }
        this.r = new ReflectedUniverse(loader);
        try {
            this.r.exec("import quicktime.QTSession");
            this.r.exec("QTSession.open()");
            needClose = true;
            this.r.exec("import quicktime.io.QTFile");
            this.r.exec("import quicktime.std.movies.Movie");
            this.r.exec("import quicktime.app.view.MoviePlayer");
            this.r.exec("import quicktime.app.view.QTImageProducer");
            this.r.exec("import quicktime.io.OpenMovieFile");
            this.r.exec("import quicktime.qd.QDDimension");
            this.r.exec("import quicktime.std.StdQTConstants");
            this.r.exec("import quicktime.std.movies.TimeInfo");
            this.r.exec("import quicktime.std.movies.Track");
            this.r.exec("import quicktime.qd.QDGraphics");
            this.r.exec("import quicktime.qd.QDRect");
            this.r.exec("import quicktime.std.image.CSequence");
            this.r.exec("import quicktime.std.image.CodecComponent");
            this.r.exec("import quicktime.std.image.ImageDescription");
            this.r.exec("import quicktime.std.movies.media.VideoMedia");
            this.r.exec("import quicktime.util.QTHandle");
            this.r.exec("import quicktime.util.RawEncodedImage");
            this.r.exec("import quicktime.util.EndianOrder");
        }
        catch (ExceptionInInitializerError err) {
            SecurityException exc;
            this.noQT = true;
            Throwable t = err.getException();
            if (t instanceof SecurityException && (exc = (SecurityException)t).getMessage().contains("expired")) {
                this.expiredQT = true;
            }
        }
        catch (Throwable t) {
            this.noQT = true;
            this.log.debug((Object)"Could not find QuickTime for Java", t);
        }
        finally {
            if (needClose) {
                try {
                    this.r.exec("QTSession.close()");
                }
                catch (Throwable t) {
                    this.log.debug((Object)"Could not close QuickTime session", t);
                }
            }
            this.initialized = true;
        }
    }

    private ClassLoader constructLoader() {
        URL[] paths = null;
        if (MAC_OS_X) {
            try {
                paths = new URL[]{new URL("file:/System/Library/Java/Extensions/QTJava.zip")};
            }
            catch (MalformedURLException exc) {
                this.log.info((Object)"", (Throwable)exc);
            }
            return paths == null ? null : new URLClassLoader(paths);
        }
        try {
            String windir = System.getProperty("java.library.path");
            StringTokenizer st = new StringTokenizer(windir, ";");
            while (st.hasMoreTokens()) {
                File f = new File(st.nextToken(), "QTJava.zip");
                if (!f.exists()) continue;
                try {
                    paths = new URL[]{f.toURI().toURL()};
                }
                catch (MalformedURLException exc) {
                    this.log.info((Object)"", (Throwable)exc);
                }
                return paths == null ? null : new URLClassLoader(paths);
            }
        }
        catch (SecurityException e) {
            this.log.warn((Object)"Cannot read value of 'java.library.path'", (Throwable)e);
        }
        return null;
    }
}

