/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller.tracking;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.scijava.Context;
import sc.fiji.filamentdetector.gui.controller.tracking.AbstractFilamentsTrackerController;
import sc.fiji.filamentdetector.gui.fxwidgets.SliderLabelSynchronizer;
import sc.fiji.filamentdetector.tracking.BBoxLAPFilamentsTracker;
import sc.fiji.filamentdetector.tracking.FilamentsTracker;

public class BBoxLAPFilamentsTrackerController
extends AbstractFilamentsTrackerController {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/tracking/BBoxLAPFilamentsTrackerView.fxml";
    @FXML
    private Slider costThresholdSlider;
    @FXML
    private TextField costThresholdField;
    @FXML
    private Slider maxFrameGapSlider;
    @FXML
    private TextField maxFrameGapField;
    @FXML
    private CheckBox interpolateFilamentsCheckbox;
    private SliderLabelSynchronizer costThresholdSync;
    private SliderLabelSynchronizer maxFrameGapSync;
    private BBoxLAPFilamentsTracker filamentsTracker;

    public BBoxLAPFilamentsTrackerController(Context context, FilamentsTracker filamentsTracker) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentsTracker = (BBoxLAPFilamentsTracker)filamentsTracker;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.costThresholdSync = new SliderLabelSynchronizer(this.costThresholdSlider, this.costThresholdField);
        this.costThresholdSync.setTooltip("Discard links between filaments when the IoU of the bounding boxes is below this value (0 to 1).");
        this.costThresholdSync.setValue(this.filamentsTracker.getCostThreshold());
        this.maxFrameGapSync = new SliderLabelSynchronizer(this.maxFrameGapSlider, this.maxFrameGapField);
        this.maxFrameGapSync.setValue(this.filamentsTracker.getMaxFrameGap());
        this.interpolateFilamentsCheckbox.setSelected(this.filamentsTracker.isInterpolateFilaments());
    }

    @FXML
    void updateTrackingParameters(Event event) {
        if (this.costThresholdSync.isEvent(event)) {
            this.costThresholdSync.update(event);
            this.filamentsTracker.setCostThreshold(this.costThresholdSync.getValue());
        } else if (this.maxFrameGapSync.isEvent(event)) {
            this.maxFrameGapSync.update(event);
            this.filamentsTracker.setMaxFrameGap(this.maxFrameGapSync.getValue());
        } else if (event.getSource().equals(this.interpolateFilamentsCheckbox)) {
            this.filamentsTracker.setInterpolateFilaments(this.interpolateFilamentsCheckbox.isSelected());
        }
    }
}

