/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.fit;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.action.fit.AbstractSpotFitter;
import fiji.plugin.trackmate.detection.DetectionUtils;
import ij.ImagePlus;
import net.imglib2.Point;
import net.imglib2.util.Util;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.fitting.leastsquares.ParameterValidator;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.Pair;

public class SpotGaussianFitter3D
extends AbstractSpotFitter {
    public SpotGaussianFitter3D(ImagePlus imp, int channel) {
        super(imp, channel);
        assert (!DetectionUtils.is2D(imp));
    }

    @Override
    public void process(Iterable<Spot> spots, Logger logger) {
        super.process(spots, logger);
    }

    @Override
    public void fit(Spot spot) {
        int frame = spot.getFeature("FRAME").intValue();
        double sigma = spot.getFeature("RADIUS") / Math.sqrt(2.0);
        double pixelSigmaXY = sigma / this.calibration[0];
        double pixelSigmaZ = sigma / this.calibration[2];
        double x0 = spot.getDoublePosition(0) / this.calibration[0];
        double y0 = spot.getDoublePosition(1) / this.calibration[1];
        double z0 = spot.getDoublePosition(2) / this.calibration[2];
        long spanXY = (long)Math.ceil(2.0 * pixelSigmaXY) + 1L;
        long spanZ = (long)Math.ceil(2.0 * pixelSigmaZ) + 1L;
        AbstractSpotFitter.Observation obs = this.gatherObservationData(new Point(new long[]{Math.round(x0), Math.round(y0), Math.round(z0)}), new long[]{spanXY, spanXY, spanZ}, frame);
        SpotGaussianFitter3D.clipBackground(obs);
        double bstartXY = 1.0 / (2.0 * pixelSigmaXY * pixelSigmaXY);
        double maxSigmaXY = 2.0 * pixelSigmaXY;
        double minBxy = 1.0 / (2.0 * maxSigmaXY * maxSigmaXY);
        double bstartZ = 1.0 / (2.0 * pixelSigmaZ * pixelSigmaZ);
        double maxSigmaZ = 2.0 * pixelSigmaZ;
        double minBz = 1.0 / (2.0 * maxSigmaZ * maxSigmaZ);
        MyGaussian3D gauss = new MyGaussian3D(obs.pos, minBxy, minBz);
        double ampstart = Util.max((double[])obs.values);
        LeastSquaresProblem lsq = new LeastSquaresBuilder().start(new double[]{x0, y0, z0, ampstart, bstartXY, bstartZ}).model((MultivariateJacobianFunction)gauss).parameterValidator((ParameterValidator)gauss).target(obs.values).lazyEvaluation(false).maxEvaluations(1000).maxIterations(1000).build();
        try {
            LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(lsq);
            RealVector fit = optimum.getPoint();
            double fitX = fit.getEntry(0) * this.calibration[0];
            double fitY = fit.getEntry(1) * this.calibration[1];
            double fitZ = fit.getEntry(2) * this.calibration[2];
            double fitSigmaXY = 1.0 / Math.sqrt(2.0 * fit.getEntry(4));
            double fitRadiusXY = fitSigmaXY * Math.sqrt(2.0) * this.calibration[0];
            spot.putFeature("POSITION_X", fitX);
            spot.putFeature("POSITION_Y", fitY);
            spot.putFeature("POSITION_Z", fitZ);
            spot.putFeature("RADIUS", fitRadiusXY);
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    private static class MyGaussian3D
    implements MultivariateJacobianFunction,
    ParameterValidator {
        private final long[][] pos;
        private final double minBxy;
        private final double minBz;

        public MyGaussian3D(long[][] pos, double minBxy, double minBz) {
            this.pos = pos;
            this.minBxy = minBxy;
            this.minBz = minBz;
        }

        public Pair<RealVector, RealMatrix> value(RealVector point) {
            double x0 = point.getEntry(0);
            double y0 = point.getEntry(1);
            double z0 = point.getEntry(2);
            double A = point.getEntry(3);
            double bXY = point.getEntry(4);
            double bZ = point.getEntry(5);
            double[] vals = new double[this.pos[0].length];
            double[][] grad = new double[this.pos[0].length][6];
            for (int i = 0; i < vals.length; ++i) {
                long x = this.pos[0][i];
                long y = this.pos[1][i];
                long z = this.pos[2][i];
                double dx = (double)x - x0;
                double dy = (double)y - y0;
                double dz = (double)z - z0;
                double sumSq = -bXY * (dx * dx + dy * dy) - bZ * dz * dz;
                double E = Math.exp(sumSq);
                vals[i] = A * E;
                grad[i][0] = A * bXY * E * 2.0 * dx;
                grad[i][1] = A * bXY * E * 2.0 * dy;
                grad[i][2] = A * bZ * E * 2.0 * dz;
                grad[i][3] = E;
                grad[i][4] = -A * E * (dx * dx + dy * dy);
                grad[i][5] = -A * E * (dz * dz);
            }
            ArrayRealVector out = new ArrayRealVector(vals);
            Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(grad, false);
            return new Pair((Object)out, (Object)jacobian);
        }

        public RealVector validate(RealVector params) {
            params.setEntry(3, Math.abs(params.getEntry(3)));
            double bXY = Math.max(this.minBxy, Math.abs(params.getEntry(4)));
            params.setEntry(4, bXY);
            double bZ = Math.max(this.minBz, Math.abs(params.getEntry(5)));
            params.setEntry(5, bZ);
            return params;
        }
    }
}

