/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DogDetector;
import fiji.plugin.trackmate.detection.LogDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.DogDetectorConfigurationPanel;
import fiji.plugin.trackmate.util.TMUtils;
import net.imagej.ImgPlusMetadata;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class DogDetectorFactory<T extends RealType<T> & NativeType<T>>
extends LogDetectorFactory<T> {
    public static final String THIS_DETECTOR_KEY = "DOG_DETECTOR";
    public static final String THIS_NAME = "DoG detector";
    public static final String THIS_INFO_TEXT = "<html>This detector is based on an approximation of the LoG operator <br> by differences of Gaussian (DoG). Computations are made in direct space. <br>It is the quickest for small spot sizes (< ~5 pixels). <p> Spots found too close are suppressed. This detector can do sub-pixel <br>localization of spots using a quadratic fitting scheme. It is based on <br>the scale-space framework made by Stephan Preibisch for ImgLib. </html>";

    @Override
    public SpotDetector<T> getDetector(Interval interval, int frame) {
        double radius = (Double)this.settings.get("RADIUS");
        double threshold = (Double)this.settings.get("THRESHOLD");
        boolean doMedian = (Boolean)this.settings.get("DO_MEDIAN_FILTERING");
        boolean doSubpixel = (Boolean)this.settings.get("DO_SUBPIXEL_LOCALIZATION");
        double[] calibration = TMUtils.getSpatialCalibration((ImgPlusMetadata)this.img);
        RandomAccessibleInterval imFrame = this.prepareFrameImg(frame);
        DogDetector detector = new DogDetector(imFrame, interval, calibration, radius, threshold, doSubpixel, doMedian);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public String getKey() {
        return THIS_DETECTOR_KEY;
    }

    @Override
    public String getName() {
        return THIS_NAME;
    }

    @Override
    public String getInfoText() {
        return THIS_INFO_TEXT;
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new DogDetectorConfigurationPanel(lSettings, model, THIS_INFO_TEXT, THIS_NAME);
    }

    @Override
    public DogDetectorFactory<T> copy() {
        return new DogDetectorFactory<T>();
    }
}

