/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.AbstractFeatureGrapher;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.features.SpotCollectionDataset;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.util.List;

public class SpotFeatureGrapher
extends AbstractFeatureGrapher {
    private final List<Spot> spots;
    private final SelectionModel selectionModel;
    private final Model model;
    private final DisplaySettings ds;
    private final boolean addLines;

    public SpotFeatureGrapher(List<Spot> spots, String xFeature, List<String> yFeatures, Model model, SelectionModel selectionModel, DisplaySettings displaySettings, boolean addLines) {
        super(xFeature, yFeatures, model.getFeatureModel().getSpotFeatureDimensions().get(xFeature), model.getFeatureModel().getSpotFeatureDimensions(), model.getFeatureModel().getSpotFeatureNames(), model.getSpaceUnits(), model.getTimeUnits());
        this.spots = spots;
        this.model = model;
        this.selectionModel = selectionModel;
        this.ds = displaySettings;
        this.addLines = addLines;
    }

    @Override
    protected ModelDataset buildMainDataSet(List<String> targetYFeatures) {
        return new SpotCollectionDataset(this.model, this.selectionModel, this.ds, this.xFeature, targetYFeatures, this.spots, this.addLines);
    }
}

