/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.gui.components.ModuleChooserPanel;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.providers.TrackerProvider;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import java.util.Map;

public class ChooseTrackerDescriptor
extends WizardPanelDescriptor {
    private static final String KEY = "ChooseTracker";
    private final TrackMate trackmate;
    private final TrackerProvider trackerProvider;

    public ChooseTrackerDescriptor(TrackerProvider trackerProvider, TrackMate trackmate) {
        super(KEY);
        this.trackmate = trackmate;
        this.trackerProvider = trackerProvider;
        String selectedTracker = "SIMPLE_SPARSE_LAP_TRACKER";
        if (null != trackmate.getSettings().trackerFactory) {
            selectedTracker = trackmate.getSettings().trackerFactory.getKey();
        }
        this.targetPanel = new ModuleChooserPanel<SpotTrackerFactory>(trackerProvider, "tracker", selectedTracker);
    }

    private void setCurrentChoiceFromPlugin() {
        String key = "SIMPLE_SPARSE_LAP_TRACKER";
        if (null != this.trackmate.getSettings().trackerFactory) {
            key = this.trackmate.getSettings().trackerFactory.getKey();
        }
        ModuleChooserPanel component = (ModuleChooserPanel)this.targetPanel;
        component.setSelectedModuleKey(key);
    }

    @Override
    public void displayingPanel() {
        this.setCurrentChoiceFromPlugin();
    }

    @Override
    public void aboutToHidePanel() {
        ModuleChooserPanel component = (ModuleChooserPanel)this.targetPanel;
        String trackerKey = component.getSelectedModuleKey();
        SpotTrackerFactory factory = (SpotTrackerFactory)this.trackerProvider.getFactory(trackerKey);
        if (null == factory) {
            this.trackmate.getModel().getLogger().error("[ChooseTrackerDescriptor] Cannot find tracker named " + trackerKey + " in current TrackMate modules.");
            return;
        }
        this.trackmate.getSettings().trackerFactory = factory;
        Map<String, Object> currentSettings = this.trackmate.getSettings().trackerSettings;
        if (!factory.checkSettingsValidity(currentSettings)) {
            Map<String, Object> defaultSettings = factory.getDefaultSettings();
            this.trackmate.getSettings().trackerSettings = defaultSettings;
        }
        SettingsPersistence.saveLastUsedSettings(this.trackmate.getSettings(), this.trackmate.getModel().getLogger());
    }

    @Override
    public Runnable getBackwardRunnable() {
        return () -> this.trackmate.getModel().clearTracks(true);
    }
}

