/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.org.objectweb.asm.tree.AbstractInsnNode;
import org.jruby.org.objectweb.asm.tree.InsnList;
import org.jruby.org.objectweb.asm.tree.InsnNode;
import org.jruby.org.objectweb.asm.tree.JumpInsnNode;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.LocalVariableNode;
import org.jruby.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSRInlinerAdapter
extends MethodNode
implements Opcodes {
    private static final boolean LOGGING = false;
    private final Map<LabelNode, BitSet> subroutineHeads = new HashMap<LabelNode, BitSet>();
    private final BitSet mainSubroutine = new BitSet();
    final BitSet dualCitizens = new BitSet();

    public JSRInlinerAdapter(MethodVisitor mv, int access, String name2, String desc, String signature, String[] exceptions) {
        this(393216, mv, access, name2, desc, signature, exceptions);
        if (this.getClass() != JSRInlinerAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected JSRInlinerAdapter(int api, MethodVisitor mv, int access, String name2, String desc, String signature, String[] exceptions) {
        super(api, access, name2, desc, signature, exceptions);
        this.mv = mv;
    }

    @Override
    public void visitJumpInsn(int opcode, Label lbl) {
        super.visitJumpInsn(opcode, lbl);
        LabelNode ln = ((JumpInsnNode)this.instructions.getLast()).label;
        if (opcode == 168 && !this.subroutineHeads.containsKey(ln)) {
            this.subroutineHeads.put(ln, new BitSet());
        }
    }

    @Override
    public void visitEnd() {
        if (!this.subroutineHeads.isEmpty()) {
            this.markSubroutines();
            this.emitCode();
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    private void markSubroutines() {
        BitSet anyvisited = new BitSet();
        this.markSubroutineWalk(this.mainSubroutine, 0, anyvisited);
        for (Map.Entry<LabelNode, BitSet> entry : this.subroutineHeads.entrySet()) {
            LabelNode lab = entry.getKey();
            BitSet sub3 = entry.getValue();
            int index2 = this.instructions.indexOf(lab);
            this.markSubroutineWalk(sub3, index2, anyvisited);
        }
    }

    private void markSubroutineWalk(BitSet sub3, int index2, BitSet anyvisited) {
        this.markSubroutineWalkDFS(sub3, index2, anyvisited);
        boolean loop2 = true;
        while (loop2) {
            loop2 = false;
            for (TryCatchBlockNode trycatch : this.tryCatchBlocks) {
                int handlerindex = this.instructions.indexOf(trycatch.handler);
                if (sub3.get(handlerindex)) continue;
                int startindex = this.instructions.indexOf(trycatch.start);
                int endindex = this.instructions.indexOf(trycatch.end);
                int nextbit = sub3.nextSetBit(startindex);
                if (nextbit == -1 || nextbit >= endindex) continue;
                this.markSubroutineWalkDFS(sub3, handlerindex, anyvisited);
                loop2 = true;
            }
        }
    }

    private void markSubroutineWalkDFS(BitSet sub3, int index2, BitSet anyvisited) {
        do {
            LabelNode l;
            int i2;
            int destidx;
            AbstractInsnNode node = this.instructions.get(index2);
            if (sub3.get(index2)) {
                return;
            }
            sub3.set(index2);
            if (anyvisited.get(index2)) {
                this.dualCitizens.set(index2);
            }
            anyvisited.set(index2);
            if (node.getType() == 7 && node.getOpcode() != 168) {
                JumpInsnNode jnode = (JumpInsnNode)node;
                destidx = this.instructions.indexOf(jnode.label);
                this.markSubroutineWalkDFS(sub3, destidx, anyvisited);
            }
            if (node.getType() == 11) {
                TableSwitchInsnNode tsnode = (TableSwitchInsnNode)node;
                destidx = this.instructions.indexOf(tsnode.dflt);
                this.markSubroutineWalkDFS(sub3, destidx, anyvisited);
                for (i2 = tsnode.labels.size() - 1; i2 >= 0; --i2) {
                    l = tsnode.labels.get(i2);
                    destidx = this.instructions.indexOf(l);
                    this.markSubroutineWalkDFS(sub3, destidx, anyvisited);
                }
            }
            if (node.getType() == 12) {
                LookupSwitchInsnNode lsnode = (LookupSwitchInsnNode)node;
                destidx = this.instructions.indexOf(lsnode.dflt);
                this.markSubroutineWalkDFS(sub3, destidx, anyvisited);
                for (i2 = lsnode.labels.size() - 1; i2 >= 0; --i2) {
                    l = lsnode.labels.get(i2);
                    destidx = this.instructions.indexOf(l);
                    this.markSubroutineWalkDFS(sub3, destidx, anyvisited);
                }
            }
            switch (this.instructions.get(index2).getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
        } while (++index2 < this.instructions.size());
    }

    private void emitCode() {
        LinkedList<Instantiation> worklist = new LinkedList<Instantiation>();
        worklist.add(new Instantiation(null, this.mainSubroutine));
        InsnList newInstructions = new InsnList();
        ArrayList<TryCatchBlockNode> newTryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        ArrayList<LocalVariableNode> newLocalVariables = new ArrayList<LocalVariableNode>();
        while (!worklist.isEmpty()) {
            Instantiation inst = (Instantiation)worklist.removeFirst();
            this.emitSubroutine(inst, worklist, newInstructions, newTryCatchBlocks, newLocalVariables);
        }
        this.instructions = newInstructions;
        this.tryCatchBlocks = newTryCatchBlocks;
        this.localVariables = newLocalVariables;
    }

    private void emitSubroutine(Instantiation instant, List<Instantiation> worklist, InsnList newInstructions, List<TryCatchBlockNode> newTryCatchBlocks, List<LocalVariableNode> newLocalVariables) {
        LabelNode end2;
        LabelNode start2;
        LabelNode duplbl = null;
        int c = this.instructions.size();
        for (int i2 = 0; i2 < c; ++i2) {
            AbstractInsnNode insn = this.instructions.get(i2);
            Instantiation owner2 = instant.findOwner(i2);
            if (insn.getType() == 8) {
                LabelNode ilbl = (LabelNode)insn;
                LabelNode remap = instant.rangeLabel(ilbl);
                if (remap == duplbl) continue;
                newInstructions.add(remap);
                duplbl = remap;
                continue;
            }
            if (owner2 != instant) continue;
            if (insn.getOpcode() == 169) {
                LabelNode retlabel = null;
                Instantiation p2 = instant;
                while (p2 != null) {
                    if (p2.subroutine.get(i2)) {
                        retlabel = p2.returnLabel;
                    }
                    p2 = p2.previous;
                }
                if (retlabel == null) {
                    throw new RuntimeException("Instruction #" + i2 + " is a RET not owned by any subroutine");
                }
                newInstructions.add(new JumpInsnNode(167, retlabel));
                continue;
            }
            if (insn.getOpcode() == 168) {
                LabelNode lbl = ((JumpInsnNode)insn).label;
                BitSet sub3 = this.subroutineHeads.get(lbl);
                Instantiation newinst = new Instantiation(instant, sub3);
                LabelNode startlbl = newinst.gotoLabel(lbl);
                newInstructions.add(new InsnNode(1));
                newInstructions.add(new JumpInsnNode(167, startlbl));
                newInstructions.add(newinst.returnLabel);
                worklist.add(newinst);
                continue;
            }
            newInstructions.add(insn.clone(instant));
        }
        for (TryCatchBlockNode trycatch : this.tryCatchBlocks) {
            start2 = instant.rangeLabel(trycatch.start);
            if (start2 == (end2 = instant.rangeLabel(trycatch.end))) continue;
            LabelNode handler = instant.gotoLabel(trycatch.handler);
            if (start2 == null || end2 == null || handler == null) {
                throw new RuntimeException("Internal error!");
            }
            newTryCatchBlocks.add(new TryCatchBlockNode(start2, end2, handler, trycatch.type));
        }
        for (LocalVariableNode lvnode : this.localVariables) {
            start2 = instant.rangeLabel(lvnode.start);
            if (start2 == (end2 = instant.rangeLabel(lvnode.end))) continue;
            newLocalVariables.add(new LocalVariableNode(lvnode.name, lvnode.desc, lvnode.signature, start2, end2, lvnode.index));
        }
    }

    private static void log(String str) {
        System.err.println(str);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Instantiation
    extends AbstractMap<LabelNode, LabelNode> {
        final Instantiation previous;
        public final BitSet subroutine;
        public final Map<LabelNode, LabelNode> rangeTable = new HashMap<LabelNode, LabelNode>();
        public final LabelNode returnLabel;

        Instantiation(Instantiation prev, BitSet sub3) {
            this.previous = prev;
            this.subroutine = sub3;
            Instantiation p2 = prev;
            while (p2 != null) {
                if (p2.subroutine == sub3) {
                    throw new RuntimeException("Recursive invocation of " + sub3);
                }
                p2 = p2.previous;
            }
            this.returnLabel = prev != null ? new LabelNode() : null;
            LabelNode duplbl = null;
            int c = JSRInlinerAdapter.this.instructions.size();
            for (int i2 = 0; i2 < c; ++i2) {
                AbstractInsnNode insn = JSRInlinerAdapter.this.instructions.get(i2);
                if (insn.getType() == 8) {
                    LabelNode ilbl = (LabelNode)insn;
                    if (duplbl == null) {
                        duplbl = new LabelNode();
                    }
                    this.rangeTable.put(ilbl, duplbl);
                    continue;
                }
                if (this.findOwner(i2) != this) continue;
                duplbl = null;
            }
        }

        public Instantiation findOwner(int i2) {
            if (!this.subroutine.get(i2)) {
                return null;
            }
            if (!JSRInlinerAdapter.this.dualCitizens.get(i2)) {
                return this;
            }
            Instantiation own = this;
            Instantiation p2 = this.previous;
            while (p2 != null) {
                if (p2.subroutine.get(i2)) {
                    own = p2;
                }
                p2 = p2.previous;
            }
            return own;
        }

        public LabelNode gotoLabel(LabelNode l) {
            Instantiation owner2 = this.findOwner(JSRInlinerAdapter.this.instructions.indexOf(l));
            return owner2.rangeTable.get(l);
        }

        public LabelNode rangeLabel(LabelNode l) {
            return this.rangeTable.get(l);
        }

        @Override
        public Set<Map.Entry<LabelNode, LabelNode>> entrySet() {
            return null;
        }

        @Override
        public LabelNode get(Object o) {
            return this.gotoLabel((LabelNode)o);
        }
    }
}

