/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.FixedCapacitySet;
import com.sun.javafx.css.ImmutablePseudoClassSetsCache;
import com.sun.javafx.css.PseudoClassState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.css.Match;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;

@Deprecated(since="23", forRemoval=true)
public final class SimpleSelector
extends Selector {
    private final String name;
    private static final Map<String, Integer> styleClassMap = new HashMap<String, Integer>(64);
    private static final List<StyleClass> styleClasses = new ArrayList<StyleClass>();
    private final FixedCapacitySet<String> selectorStyleClassNames;
    private transient Set<StyleClass> cachedStyleClasses;
    private final String id;
    private final Set<PseudoClass> pseudoClassState;
    private final boolean matchOnName;
    private final boolean matchOnId;
    private final boolean matchOnStyleClass;
    private final NodeOrientation nodeOrientation;

    public String getName() {
        return this.name;
    }

    public List<String> getStyleClasses() {
        return List.copyOf(this.selectorStyleClassNames);
    }

    public Set<StyleClass> getStyleClassSet() {
        if (this.cachedStyleClasses == null) {
            this.cachedStyleClasses = this.getStyleClassNames().stream().map(SimpleSelector::getStyleClass).collect(Collectors.toUnmodifiableSet());
        }
        return this.cachedStyleClasses;
    }

    private static StyleClass getStyleClass(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("styleClass cannot be null or empty String");
        }
        StyleClass styleClass = null;
        Integer n = styleClassMap.get(string);
        int n2 = n != null ? n : -1;
        int n3 = styleClasses.size();
        assert (n2 < n3);
        if (n2 != -1 && n2 < n3) {
            styleClass = styleClasses.get(n2);
        }
        if (styleClass == null) {
            styleClass = new StyleClass(string, n3);
            styleClasses.add(styleClass);
            styleClassMap.put(string, n3);
        }
        return styleClass;
    }

    public String getId() {
        return this.id;
    }

    Set<PseudoClass> getPseudoClassStates() {
        return this.pseudoClassState;
    }

    public NodeOrientation getNodeOrientation() {
        return this.nodeOrientation;
    }

    SimpleSelector(String string, List<String> list, List<String> list2, String string2) {
        this.name = string == null ? "*" : string;
        this.matchOnName = string != null && !"".equals(string) && !"*".equals(string);
        this.selectorStyleClassNames = list == null ? FixedCapacitySet.of(0) : this.convertStyleClassNamesToSet(list);
        this.selectorStyleClassNames.freeze();
        this.matchOnStyleClass = this.selectorStyleClassNames.size() > 0;
        PseudoClassState pseudoClassState = new PseudoClassState();
        NodeOrientation nodeOrientation = NodeOrientation.INHERIT;
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                String string3 = list2.get(i);
                if (string3 == null || string3.isEmpty()) continue;
                if ("dir(".regionMatches(true, 0, string3, 0, 4)) {
                    boolean bl = "dir(rtl)".equalsIgnoreCase(string3);
                    nodeOrientation = bl ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.LEFT_TO_RIGHT;
                    continue;
                }
                pseudoClassState.add(PseudoClassState.getPseudoClass(string3));
            }
        }
        this.pseudoClassState = ImmutablePseudoClassSetsCache.of(pseudoClassState);
        this.nodeOrientation = nodeOrientation;
        this.id = string2 == null ? "" : string2;
        this.matchOnId = string2 != null && !"".equals(string2);
    }

    @Override
    public Set<String> getStyleClassNames() {
        return this.selectorStyleClassNames;
    }

    private FixedCapacitySet<String> convertStyleClassNamesToSet(List<String> list) {
        FixedCapacitySet<String> fixedCapacitySet = FixedCapacitySet.of(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string == null || string.isEmpty()) continue;
            fixedCapacitySet.add(string);
        }
        return fixedCapacitySet;
    }

    @Override
    public Match createMatch() {
        int n = this.matchOnId ? 1 : 0;
        int n2 = this.selectorStyleClassNames.size();
        return new Match(this, this.pseudoClassState, n, n2);
    }

    @Override
    public boolean applies(Styleable styleable) {
        boolean bl;
        boolean bl2;
        Object object;
        NodeOrientation nodeOrientation;
        if (this.nodeOrientation != NodeOrientation.INHERIT && styleable instanceof Node && ((nodeOrientation = ((Node)(object = (Node)styleable)).getNodeOrientation()) == NodeOrientation.INHERIT ? ((Node)object).getEffectiveNodeOrientation() != this.nodeOrientation : nodeOrientation != this.nodeOrientation)) {
            return false;
        }
        if (this.matchOnId && !(bl2 = this.id.equals(object = styleable.getId()))) {
            return false;
        }
        if (this.matchOnName && !(bl = this.name.equals(object = styleable.getTypeSelector()))) {
            return false;
        }
        return !this.matchOnStyleClass || this.matchesStyleClasses((List<String>)styleable.getStyleClass());
    }

    @Override
    public boolean applies(Styleable styleable, Set<PseudoClass>[] setArray, int n) {
        boolean bl = this.applies(styleable);
        if (bl && setArray != null && n < setArray.length) {
            if (setArray[n] == null) {
                setArray[n] = new PseudoClassState();
            }
            setArray[n].addAll(this.pseudoClassState);
        }
        return bl;
    }

    @Override
    public boolean stateMatches(Styleable styleable, Set<PseudoClass> set) {
        return set != null ? set.containsAll(this.pseudoClassState) : false;
    }

    private boolean matchesStyleClasses(List<String> list) {
        if (list.size() < this.selectorStyleClassNames.size()) {
            return false;
        }
        return this.selectorStyleClassNames.isSuperSetOf(list);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleSelector simpleSelector = (SimpleSelector)object;
        if (this.name == null ? simpleSelector.name != null : !this.name.equals(simpleSelector.name)) {
            return false;
        }
        if (this.id == null ? simpleSelector.id != null : !this.id.equals(simpleSelector.id)) {
            return false;
        }
        if (!this.selectorStyleClassNames.equals(simpleSelector.selectorStyleClassNames)) {
            return false;
        }
        return this.pseudoClassState.equals(simpleSelector.pseudoClassState);
    }

    public int hashCode() {
        int n = 7;
        n = 31 * (n + this.name.hashCode());
        n = 31 * (n + this.selectorStyleClassNames.hashCode());
        n = 31 * (n + this.selectorStyleClassNames.hashCode());
        n = this.id != null ? 31 * (n + this.id.hashCode()) : 0;
        n = 31 * (n + this.pseudoClassState.hashCode());
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            stringBuilder.append(this.name);
        } else {
            stringBuilder.append("*");
        }
        for (String object : this.selectorStyleClassNames) {
            stringBuilder.append('.').append(object);
        }
        if (this.id != null && !this.id.isEmpty()) {
            stringBuilder.append('#');
            stringBuilder.append(this.id);
        }
        for (PseudoClass pseudoClass : this.pseudoClassState) {
            stringBuilder.append(':').append(pseudoClass.getPseudoClassName());
        }
        return stringBuilder.toString();
    }

    @Override
    protected final void writeBinary(DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        super.writeBinary(dataOutputStream, stringStore);
        dataOutputStream.writeShort(stringStore.addString(this.name));
        dataOutputStream.writeShort(this.selectorStyleClassNames.size());
        for (String string : this.selectorStyleClassNames) {
            dataOutputStream.writeShort(stringStore.addString(string));
        }
        dataOutputStream.writeShort(stringStore.addString(this.id));
        int n = this.pseudoClassState.size() + (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT || this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT ? 1 : 0);
        dataOutputStream.writeShort(n);
        for (PseudoClass pseudoClass : this.pseudoClassState) {
            dataOutputStream.writeShort(stringStore.addString(pseudoClass.getPseudoClassName()));
        }
        if (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            dataOutputStream.writeShort(stringStore.addString("dir(rtl)"));
        } else if (this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT) {
            dataOutputStream.writeShort(stringStore.addString("dir(ltr)"));
        }
    }

    static SimpleSelector readBinary(int n, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        int n2 = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(stringArray[dataInputStream.readShort()]);
        }
        String string2 = stringArray[dataInputStream.readShort()];
        int n3 = dataInputStream.readShort();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n3; ++i) {
            arrayList2.add(stringArray[dataInputStream.readShort()]);
        }
        return new SimpleSelector(string, arrayList, arrayList2, string2);
    }
}

