/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import org.scijava.ui.ARGBPlane;
import org.scijava.ui.SystemClipboard;

public class AWTClipboard
implements SystemClipboard,
Transferable {
    private static Clipboard clipboard = null;
    private ARGBPlane plane;

    public AWTClipboard() {
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    public void pixelsToSystemClipboard(ARGBPlane argbPlane) {
        this.plane = argbPlane;
        try {
            clipboard.setContents(this, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        BufferedImage img = new BufferedImage(this.plane.getWidth(), this.plane.getHeight(), 2);
        for (int x = 0; x < this.plane.getWidth(); ++x) {
            for (int y = 0; y < this.plane.getHeight(); ++y) {
                img.setRGB(x, y, this.plane.getARGB(x, y));
            }
        }
        return img;
    }
}

