/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;

public class CoordinateSystem {
    public static final String KEY = "coordinateSystems";
    protected final String name;
    protected final Axis[] axes;

    public CoordinateSystem(String name, int nd) {
        this.name = name;
        this.axes = new Axis[nd];
        for (int i = 0; i < nd; ++i) {
            this.axes[i] = AxisUtils.unknownAxis();
        }
    }

    public CoordinateSystem(String name, Axis[] axes) {
        this.name = name;
        this.axes = axes;
    }

    public String getName() {
        return this.name;
    }

    public Axis[] getAxes() {
        return this.axes;
    }

    public int numDimensions() {
        return this.axes.length;
    }

    public String[] getAxisNames() {
        return (String[])Arrays.stream(this.axes).map(Axis::getName).toArray(String[]::new);
    }

    public String[] getAxisTypes() {
        return (String[])Arrays.stream(this.axes).map(Axis::getType).toArray(String[]::new);
    }

    public String[] getUnits() {
        return (String[])Arrays.stream(this.axes).map(Axis::getUnit).toArray(String[]::new);
    }

    public Axis getAxis(int i) {
        return this.axes[i];
    }

    public boolean hasAxis(String label) {
        return Arrays.stream(this.axes).map(Axis::getName).anyMatch(l -> l.equals(label));
    }

    public static boolean isSuperspaceOf(String[] a, String[] b) {
        for (String l : b) {
            if (CoordinateSystem.contains(l, a)) continue;
            return false;
        }
        return true;
    }

    public boolean isSuperspaceOf(CoordinateSystem other) {
        return this.isSuperspaceOf(other.getAxisNames());
    }

    public boolean isSuperspaceOf(String[] axisLabels) {
        String[] mylabels = this.getAxisNames();
        for (String l : axisLabels) {
            if (CoordinateSystem.contains(l, mylabels)) continue;
            return false;
        }
        return true;
    }

    public boolean isSubspaceOf(CoordinateSystem other) {
        return this.isSubspaceOf(other.getAxisNames());
    }

    public static boolean isSubspaceOf(String[] a, String[] b) {
        for (String l : a) {
            if (CoordinateSystem.contains(l, b)) continue;
            return false;
        }
        return true;
    }

    public boolean isSubspaceOf(String[] axisLabels) {
        for (String l : this.getAxisNames()) {
            if (CoordinateSystem.contains(l, axisLabels)) continue;
            return false;
        }
        return true;
    }

    public CoordinateSystem subSpace(String name, String ... axisLabels) {
        return new CoordinateSystem(name, (Axis[])Arrays.stream(this.axes).filter(x -> AxisUtils.contains(x.getName(), axisLabels)).toArray(Axis[]::new));
    }

    public CoordinateSystem union(String name, CoordinateSystem space) {
        return new CoordinateSystem(name, (Axis[])Stream.concat(Arrays.stream(this.axes), Arrays.stream(space.getAxes())).toArray(Axis[]::new));
    }

    public CoordinateSystem intersection(String name, CoordinateSystem space) {
        return this.subSpace(name, space.getAxisNames());
    }

    public CoordinateSystem diff(String name, CoordinateSystem space) {
        String[] axisLabels = space.getAxisNames();
        return new CoordinateSystem(name, (Axis[])Arrays.stream(this.axes).filter(x -> !AxisUtils.contains(x.getName(), axisLabels)).toArray(Axis[]::new));
    }

    public boolean axesEquals(CoordinateSystem other) {
        return this.axesEquals(other.getAxisNames());
    }

    public boolean axesEquals(String[] axes) {
        if (axes.length != this.numDimensions()) {
            return false;
        }
        return this.isSubspaceOf(axes);
    }

    private static boolean contains(String q, String[] array) {
        for (String t : array) {
            if (!t.equals(q)) continue;
            return true;
        }
        return false;
    }

    public boolean axesLabelsMatch(String[] labels) {
        return Arrays.equals(labels, this.getAxisNames());
    }

    public boolean hasAllLabels(String[] labels) {
        if (this.numDimensions() != labels.length) {
            return false;
        }
        for (String l : labels) {
            if (Arrays.stream(this.axes).map(Axis::getName).anyMatch(x -> x.equals(l))) continue;
            return false;
        }
        return true;
    }

    public int indexOf(String label) {
        for (int i = 0; i < this.numDimensions(); ++i) {
            if (!this.getAxisNames()[i].equals(label)) continue;
            return i;
        }
        return -1;
    }

    public int[] indexesOfType(String type) {
        String[] types = this.getAxisTypes();
        return IntStream.range(0, this.numDimensions()).filter(i -> types[i].equals(type)).toArray();
    }

    public boolean equals(Object other) {
        if (other instanceof CoordinateSystem) {
            return ((CoordinateSystem)other).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static CoordinateSystem defaultArray(String name, int nd) {
        return new CoordinateSystem(name, (Axis[])IntStream.range(0, nd).mapToObj(i -> Axis.defaultArray(i)).toArray(Axis[]::new));
    }
}

