/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.mpicbg;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.SketchTikZFileObject;
import mpicbg.spim.mpicbg.TileSPIM;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.segmentation.Nucleus;
import mpicbg.spim.vis3d.VisualizationSketchTikZ;
import mpicbg.util.TransformUtils;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3d;

public class TileConfigurationSPIM {
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    private final Set<TileSPIM> tiles = new HashSet<TileSPIM>();
    private final Set<TileSPIM> fixedTiles = new HashSet<TileSPIM>();
    private double minError = Double.MAX_VALUE;
    private double maxError = 0.0;
    private double error = Double.MAX_VALUE;
    protected int debugLevel;

    public final Set<TileSPIM> getTiles() {
        return this.tiles;
    }

    public final Set<TileSPIM> getFixedTiles() {
        return this.fixedTiles;
    }

    public final double getMinError() {
        return this.minError;
    }

    public final double getMaxError() {
        return this.maxError;
    }

    public final double getError() {
        return this.error;
    }

    public TileConfigurationSPIM(int debugLevel) {
        this.debugLevel = debugLevel;
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
    }

    protected void println(String s) {
        if (this.debugLevel <= 1) {
            IOFunctions.println(s);
        }
    }

    public void clear() {
        this.tiles.clear();
        this.fixedTiles.clear();
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        this.error = Double.MAX_VALUE;
    }

    public final void addTile(TileSPIM t) {
        this.tiles.add(t);
    }

    public final void addTiles(Collection<? extends TileSPIM> t) {
        this.tiles.addAll(t);
    }

    public final void addTiles(TileConfigurationSPIM t) {
        this.tiles.addAll(t.tiles);
    }

    public final void fixTile(TileSPIM t) {
        this.fixedTiles.add(t);
    }

    protected final void update() {
        double cd = 0.0;
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        for (TileSPIM t : this.tiles) {
            t.update();
            double d = t.getDistance();
            if (d < this.minError) {
                this.minError = d;
            }
            if (d > this.maxError) {
                this.maxError = d;
            }
            cd += d;
        }
        this.error = cd /= (double)this.tiles.size();
    }

    public final void computeError() {
        this.update();
        if (this.debugLevel <= 1) {
            this.println("  average displacement: " + decimalFormat.format(this.error) + "px");
            this.println("  minimal displacement: " + decimalFormat.format(this.minError) + "px");
            this.println("  maximal displacement: " + decimalFormat.format(this.maxError) + "px");
        }
    }

    public void optimize(double maxAllowedError, int maxIterations, int maxPlateauwidth, int debugLevel) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        boolean proceed;
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        int i = 0;
        boolean bl = proceed = i < maxIterations;
        while (proceed) {
            for (TileSPIM tile : this.tiles) {
                if (this.fixedTiles.contains((Object)tile)) continue;
                tile.update();
                tile.fitModel();
                tile.update();
            }
            this.update();
            observer.add(this.error);
            if (i > maxPlateauwidth) {
                proceed = this.error > maxAllowedError;
                for (int d = maxPlateauwidth; !proceed && d >= 1; d /= 2) {
                    try {
                        proceed |= Math.abs(observer.getWideSlope(d)) > 1.0E-4;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            proceed &= ++i < maxIterations;
        }
        if (debugLevel <= 1) {
            this.println("Successfully optimized configuration of " + this.tiles.size() + " tiles after " + i + " iterations:");
            this.println("  average displacement: " + decimalFormat.format(this.error) + "px");
            this.println("  minimal displacement: " + decimalFormat.format(this.minError) + "px");
            this.println("  maximal displacement: " + decimalFormat.format(this.maxError) + "px");
        }
    }

    public void optimizeWithSketchTikZ(double maxAllowedError, int maxIterations, int maxPlateauwidth, int debugLevel) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        boolean proceed;
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        int i = 0;
        double factor = 0.005;
        boolean bl = proceed = i < maxIterations;
        while (proceed) {
            Object tile2;
            for (Object tile2 : this.tiles) {
                if (this.fixedTiles.contains(tile2)) continue;
                tile2.updateWithDections();
                if (i <= 0) continue;
                tile2.fitModel();
                tile2.updateWithDections();
            }
            SketchTikZFileObject files = SketchTikZFileObject.initOutputFile("src/templates/beadimage-movie.sk", "src/templates/movie/dros_nucleibased_" + i + ".sk");
            tile2 = this.tiles.iterator();
            while (tile2.hasNext()) {
                TileSPIM tile3 = (TileSPIM)((Object)tile2.next());
                AbstractAffineModel3D m = (AbstractAffineModel3D)tile3.getModel().copy();
                Transform3D t = TransformUtils.getTransform3D1(m);
                ViewDataBeads parent = tile3.getParent();
                Transform3D tmp = new Transform3D();
                Transform3D tmp2 = new Transform3D(t);
                tmp.setScale(new Vector3d(1.0, 1.0, parent.getZStretching()));
                tmp2.mul(tmp);
                t = tmp2;
                AbstractAffineModel3D backUp = (AbstractAffineModel3D)tile3.getModel().copy();
                backUp.set((Model)((AbstractAffineModel3D)parent.getTile().getModel()));
                parent.getTile().getModel().set((Model)TransformUtils.getAffineModel3D(t));
                System.out.println("Writing view " + parent.getName() + " @ iteration " + i);
                files.getOutput().println(VisualizationSketchTikZ.drawView(parent, 0.005));
                files.getOutput().println(VisualizationSketchTikZ.drawBeads(parent.getBeadStructure().getBeadList(), TransformUtils.getTransform3D1(m), "Bead", 0.005, 2));
                for (Bead bead : parent.getBeadStructure().getBeadList()) {
                    double distance = bead.getDistance();
                    if (!(distance >= 0.0)) continue;
                    int color = (int)Math.round(Math.log10(distance + 1.0) * 256.0);
                    if (color > 511) {
                        color = 511;
                    }
                    if (color < 0) {
                        color = 0;
                    }
                    files.getOutput().println(VisualizationSketchTikZ.drawBead(bead, TransformUtils.getTransform3D1(m), "RansacBead" + color, 0.005));
                }
                parent.getTile().getModel().set((Model)backUp);
            }
            files.finishFiles();
            this.update();
            observer.add(this.error);
            if (i > maxPlateauwidth) {
                proceed = this.error > maxAllowedError;
                for (int d = maxPlateauwidth; !proceed && d >= 1; d /= 2) {
                    try {
                        proceed |= Math.abs(observer.getWideSlope(d)) > 1.0E-4;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            proceed &= ++i < maxIterations;
        }
        if (debugLevel <= 1) {
            this.println("Successfully optimized configuration of " + this.tiles.size() + " tiles after " + i + " iterations:");
            this.println("  average displacement: " + decimalFormat.format(this.error) + "px");
            this.println("  minimal displacement: " + decimalFormat.format(this.minError) + "px");
            this.println("  maximal displacement: " + decimalFormat.format(this.maxError) + "px");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void optimizeWithSketchTikZNuclei(double maxAllowedError, int maxIterations, int maxPlateauwidth, int debugLevel) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        boolean proceed;
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        int numDetailedIterations = 5;
        double thresholdErrorFastMovie = 7.5;
        int ratioFastMovie = 8;
        ArrayList<ViewDataBeads> tilesSorted = new ArrayList<ViewDataBeads>();
        for (TileSPIM tile : this.tiles) {
            tilesSorted.add(tile.getParent());
        }
        Collections.sort(tilesSorted);
        int i = 0;
        int j = 0;
        int frame = 0;
        double factor = 0.0045000000000000005;
        int freeTiles = 0;
        for (Tile tile : this.tiles) {
            if (this.fixedTiles.contains(tile)) continue;
            ++freeTiles;
        }
        boolean bl = proceed = i < maxIterations;
        while (proceed) {
            for (ViewDataBeads view : tilesSorted) {
                TileSPIM tile1 = view.getTile();
                if (this.fixedTiles.contains((Object)tile1)) continue;
                tile1.updateWithDections();
                if (i > 0) {
                    tile1.fitModel();
                    tile1.updateWithDections();
                }
                this.update();
                if (j >= freeTiles - 1 && (j <= 6 * freeTiles || this.error > 7.5 && j % freeTiles == 0 || this.error <= 7.5 && j % (freeTiles * 8) == 0)) {
                    System.out.println(j + "(" + i + ") " + this.error + " frame=" + frame);
                    SketchTikZFileObject files = SketchTikZFileObject.initOutputFile("src/templates/fish-movie.sk", "src/templates/movie_fish/fish_" + frame + ".sk");
                    for (TileSPIM tile : this.tiles) {
                        AffineModel3D m = new AffineModel3D();
                        m.set((AffineModel3D)tile.getModel());
                        Transform3D t = TransformUtils.getTransform3D(m);
                        ViewDataBeads parent = tile.getParent();
                        Transform3D tmp = new Transform3D();
                        Transform3D tmp2 = new Transform3D(t);
                        tmp.setScale(new Vector3d(1.0, 1.0, parent.getZStretching()));
                        tmp2.mul(tmp);
                        t = tmp2;
                        AffineModel3D backUp = new AffineModel3D();
                        backUp.set((AffineModel3D)parent.getTile().getModel());
                        parent.getTile().getModel().set((Model)TransformUtils.getAffineModel3D(t));
                        files.getOutput().println(VisualizationSketchTikZ.drawView(parent, 0.0045000000000000005));
                        files.getOutput().println(VisualizationSketchTikZ.drawNuclei(parent.getNucleiStructure().getNucleiList(), TransformUtils.getTransform3D(m), 0.0045000000000000005));
                        for (Nucleus nucleus : parent.getNucleiStructure().getNucleiList()) {
                            double distance = nucleus.getDistance();
                            if (!(distance >= 0.0)) continue;
                            int color = (int)Math.round(Math.log10(distance + 1.0) * 256.0);
                            if (color > 511) {
                                color = 511;
                            }
                            if (color < 0) {
                                color = 0;
                            }
                            files.getOutput().println(VisualizationSketchTikZ.drawNucleus(nucleus, TransformUtils.getTransform3D(m), "RansacBead" + color, 0.0045000000000000005));
                        }
                        parent.getTile().getModel().set((Model)backUp);
                    }
                    files.putTextEntry(14.0f, -4.5f, "Iteration " + i + " (" + decimalFormat.format(this.error) + " px)");
                    files.finishFiles();
                    ++frame;
                }
                ++j;
            }
            this.update();
            observer.add(this.error);
            if (i > maxPlateauwidth) {
                void var19_22;
                proceed = this.error > maxAllowedError;
                int n = maxPlateauwidth;
                while (!proceed && var19_22 >= true) {
                    try {
                        proceed |= Math.abs(observer.getWideSlope((int)var19_22)) > 1.0E-4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    var19_22 /= 2;
                }
            }
            proceed &= ++i < maxIterations;
        }
        if (debugLevel <= 1) {
            this.println("Successfully optimized configuration of " + this.tiles.size() + " tiles after " + i + " iterations:");
            this.println("  average displacement: " + decimalFormat.format(this.error) + "px");
            this.println("  minimal displacement: " + decimalFormat.format(this.minError) + "px");
            this.println("  maximal displacement: " + decimalFormat.format(this.maxError) + "px");
        }
    }

    public List<Tile<?>> preAlign() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        ArrayList unAlignedTiles = new ArrayList();
        ArrayList<Tile> alignedTiles = new ArrayList<Tile>();
        if (this.getFixedTiles().size() == 0) {
            Iterator<TileSPIM> it = this.getTiles().iterator();
            alignedTiles.add(it.next());
            while (it.hasNext()) {
                unAlignedTiles.add(it.next());
            }
        } else {
            for (Tile tile : this.getTiles()) {
                if (this.getFixedTiles().contains(tile)) {
                    alignedTiles.add(tile);
                    continue;
                }
                unAlignedTiles.add(tile);
            }
        }
        ListIterator<Tile<?>> referenceIterator = alignedTiles.listIterator();
        while (referenceIterator.hasNext() && unAlignedTiles.size() != 0) {
            Tile tile = (Tile)referenceIterator.next();
            tile.apply();
            ListIterator<Tile<?>> targetIterator = unAlignedTiles.listIterator();
            while (targetIterator.hasNext()) {
                ArrayList<PointMatch> pm;
                Tile<?> targetTile = targetIterator.next();
                if (!tile.getConnectedTiles().contains(targetTile) || (pm = this.getConnectingPointMatches(targetTile, tile)).size() <= targetTile.getModel().getMinNumMatches()) continue;
                targetTile.getModel().fit(pm);
                targetIterator.remove();
                int countFwd = 0;
                while (referenceIterator.hasNext()) {
                    referenceIterator.next();
                    ++countFwd;
                }
                referenceIterator.add(targetTile);
                for (int j = 0; j < countFwd + 1; ++j) {
                    referenceIterator.previous();
                }
            }
        }
        return unAlignedTiles;
    }

    public ArrayList<PointMatch> getConnectingPointMatches(Tile<?> targetTile, Tile<?> referenceTile) {
        Set referenceMatches = referenceTile.getMatches();
        ArrayList<Point> referencePoints = new ArrayList<Point>(referenceMatches.size());
        for (PointMatch pm : referenceMatches) {
            referencePoints.add(pm.getP1());
        }
        ArrayList<PointMatch> connectedPointMatches = new ArrayList<PointMatch>();
        for (PointMatch pm : targetTile.getMatches()) {
            if (!referencePoints.contains(pm.getP2())) continue;
            connectedPointMatches.add(pm);
        }
        return connectedPointMatches;
    }
}

