/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.threshold;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.threshold.ComponentProperties;
import spim.vecmath.Point3d;

public class ConnectedComponent {
    public ArrayList<int[]> distinctLabels = new ArrayList();
    private ArrayList<ComponentProperties> components = null;
    private HashMap<Integer, Integer> labelGroups = new HashMap();

    public void equalizeLabels(Image<IntType> connectedComponents) {
        int w = connectedComponents.getDimension(0);
        int h = connectedComponents.getDimension(1);
        int d = connectedComponents.getDimension(2);
        this.components = new ArrayList();
        for (int i = 0; i < this.distinctLabels.size(); ++i) {
            this.components.add(new ComponentProperties());
        }
        LocalizableByDimCursor3D cursor = (LocalizableByDimCursor3D)connectedComponents.createLocalizableByDimCursor();
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    cursor.setPosition(x, y, z);
                    int pixel = ((IntType)cursor.getType()).get();
                    if (pixel <= 0) continue;
                    ((IntType)cursor.getType()).set(this.getLabelGroup(pixel) + 1);
                    cursor.setPosition(x, y, z);
                    ComponentProperties compProp = this.components.get(((IntType)cursor.getType()).get() - 1);
                    ++compProp.size;
                    compProp.label = ((IntType)cursor.getType()).get();
                    if (x < compProp.minX) {
                        compProp.minX = x;
                    }
                    if (y < compProp.minY) {
                        compProp.minY = y;
                    }
                    if (z < compProp.minZ) {
                        compProp.minZ = z;
                    }
                    if (x > compProp.maxX) {
                        compProp.maxX = x;
                    }
                    if (y > compProp.maxY) {
                        compProp.maxY = y;
                    }
                    if (z <= compProp.maxZ) continue;
                    compProp.maxZ = z;
                }
            }
        }
        cursor.close();
        for (ComponentProperties compProp : this.components) {
            compProp.sizeX = compProp.maxX - compProp.minX + 1;
            compProp.sizeY = compProp.maxY - compProp.minY + 1;
            compProp.sizeZ = compProp.maxZ - compProp.minZ + 1;
        }
    }

    public ArrayList<ComponentProperties> getBeads(Image<IntType> connectedComponents, Image<FloatType> img, int minSize, int maxSize, int minBlackBorder, boolean useCenterOfMass, double circularityFactor) {
        int w = connectedComponents.getDimension(0);
        int h = connectedComponents.getDimension(1);
        int d = connectedComponents.getDimension(2);
        int i = 0;
        while (i < this.components.size()) {
            ComponentProperties compProp = this.components.get(i);
            if (compProp.size < minSize || compProp.size > maxSize) {
                this.components.remove(i);
                continue;
            }
            boolean isIsolated = true;
            if (compProp.minX - minBlackBorder < 0 || compProp.maxX + minBlackBorder >= w || compProp.minY - minBlackBorder < 0 || compProp.maxY + minBlackBorder >= h || compProp.minZ - minBlackBorder < 0 || compProp.maxZ + minBlackBorder >= d) {
                isIsolated = false;
            }
            float countX = 0.0f;
            float countY = 0.0f;
            float countZ = 0.0f;
            compProp.center = new Point3d(0.0, 0.0, 0.0);
            LocalizableByDimCursor3D cursor = (LocalizableByDimCursor3D)img.createLocalizableByDimCursor();
            float maxIntensity = -3.4028235E38f;
            Point3d maxCenter = new Point3d();
            for (int z = compProp.minZ - minBlackBorder; z <= compProp.maxZ + minBlackBorder && isIsolated; ++z) {
                for (int y = compProp.minY - minBlackBorder; y <= compProp.maxY + minBlackBorder; ++y) {
                    for (int x = compProp.minX - minBlackBorder; x <= compProp.maxX + minBlackBorder; ++x) {
                        cursor.setPosition(x, y, z);
                        float value = ((FloatType)cursor.getType()).get();
                        if (useCenterOfMass) {
                            compProp.center.x += (double)((float)x * value);
                            compProp.center.y += (double)((float)y * value);
                            compProp.center.z += (double)((float)z * value);
                            countX += value;
                            countY += value;
                            countZ += value;
                            continue;
                        }
                        if (!(value > maxIntensity)) continue;
                        maxIntensity = value;
                        maxCenter.x = x;
                        maxCenter.y = y;
                        maxCenter.z = z;
                    }
                }
            }
            cursor.close();
            if (!isIsolated) {
                this.components.remove(i);
                continue;
            }
            if (useCenterOfMass) {
                compProp.center.x /= (double)countX;
                compProp.center.y /= (double)countY;
                compProp.center.z /= (double)countZ;
            } else {
                compProp.center.x = maxCenter.x;
                compProp.center.y = maxCenter.y;
                compProp.center.z = maxCenter.z;
            }
            ++i;
        }
        return this.components;
    }

    public synchronized void addLabel(int label) {
        for (int[] labelGroup : this.distinctLabels) {
            for (int knownLabel : labelGroup) {
                if (knownLabel != label) continue;
                return;
            }
        }
        this.distinctLabels.add(new int[]{label});
        this.labelGroups.put(label, this.distinctLabels.size() - 1);
    }

    public synchronized void addEqualLabels(int label1, int label2) {
        int group2;
        int group1 = this.getLabelGroup(label1);
        if (group1 != (group2 = this.getLabelGroup(label2))) {
            int i;
            int[] labelGroup1 = this.distinctLabels.get(group1);
            int[] labelGroup2 = this.distinctLabels.get(group2);
            int[] newGroup = new int[labelGroup1.length + labelGroup2.length];
            for (i = 0; i < labelGroup1.length; ++i) {
                newGroup[i] = labelGroup1[i];
            }
            for (i = 0; i < labelGroup2.length; ++i) {
                newGroup[i + labelGroup1.length] = labelGroup2[i];
            }
            if (group2 > group1) {
                this.distinctLabels.remove(group2);
                this.distinctLabels.remove(group1);
            } else {
                this.distinctLabels.remove(group1);
                this.distinctLabels.remove(group2);
            }
            this.distinctLabels.add(newGroup);
            Iterator<int[]> i2 = this.distinctLabels.iterator();
            int group = 0;
            while (i2.hasNext()) {
                int[] labelGroup;
                for (int label : labelGroup = i2.next()) {
                    this.labelGroups.put(label, group);
                }
                ++group;
            }
        }
    }

    private int getLabelGroup(int label) {
        Integer group = this.labelGroups.get(label);
        if (group == null) {
            IOFunctions.printErr("EqualLabel.getLabelGroup(): Label " + label + " not found!");
            return -1;
        }
        return group;
    }
}

