/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.interestpointregistration;

import ij.gui.GenericDialog;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import spim.Threads;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.fiji.spimdata.SpimData2;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.TransformationModel;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationSubset;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationType;

public abstract class InterestPointRegistration {
    final SpimData2 spimData1;
    final List<ViewId> viewIdsToProcess;
    final List<ChannelProcess> channelsToProcess;
    List<List<PairwiseMatch>> statistics;

    public InterestPointRegistration(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess) {
        this.spimData1 = spimData;
        this.viewIdsToProcess = viewIdsToProcess;
        this.channelsToProcess = channelsToProcess;
    }

    public abstract void addQuery(GenericDialog var1, Interest_Point_Registration.RegistrationType var2);

    public abstract boolean parseDialog(GenericDialog var1, Interest_Point_Registration.RegistrationType var2);

    public abstract InterestPointRegistration newInstance(SpimData2 var1, List<ViewId> var2, List<ChannelProcess> var3);

    public abstract String getDescription();

    protected abstract Callable<PairwiseMatch> pairwiseMatchingInstance(PairwiseMatch var1, String var2);

    protected abstract TransformationModel getTransformationModel();

    protected final boolean runGlobalOpt(GlobalOptimizationSubset subset, GlobalOptimizationType registrationType) {
        return subset.computeGlobalOpt(this.getTransformationModel().getModel(), registrationType, this.getSpimData(), this.getChannelsToProcess(), this.getDescription() + ", " + this.getTransformationModel().getDescription());
    }

    protected SpimData2 getSpimData() {
        return this.spimData1;
    }

    public List<ViewId> getViewIdsToProcess() {
        return this.viewIdsToProcess;
    }

    public List<ChannelProcess> getChannelsToProcess() {
        return this.channelsToProcess;
    }

    public List<List<PairwiseMatch>> getStatistics() {
        return this.statistics;
    }

    public boolean register(GlobalOptimizationType registrationType, boolean save, boolean collectStatistics) {
        SpimData2 spimData = this.getSpimData();
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting registration");
        if (collectStatistics) {
            this.statistics = new ArrayList<List<PairwiseMatch>>();
        }
        List<GlobalOptimizationSubset> list = registrationType.getAllViewPairs();
        int successfulRuns = 0;
        for (GlobalOptimizationSubset subset : list) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Finding correspondences for subset: " + subset.getDescription());
            List<PairwiseMatch> pairs = subset.getViewPairs();
            ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
            ArrayList<Callable<PairwiseMatch>> tasks = new ArrayList<Callable<PairwiseMatch>>();
            for (PairwiseMatch pair : pairs) {
                ViewDescription viewA = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(pair.getViewIdA());
                ViewDescription viewB = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(pair.getViewIdB());
                String description = "[TP=" + viewA.getTimePoint().getName() + " angle=" + ((ViewSetup)viewA.getViewSetup()).getAngle().getName() + ", ch=" + ((ViewSetup)viewA.getViewSetup()).getChannel().getName() + ", illum=" + ((ViewSetup)viewA.getViewSetup()).getIllumination().getName() + " >>> TP=" + viewB.getTimePoint().getName() + " angle=" + ((ViewSetup)viewB.getViewSetup()).getAngle().getName() + ", ch=" + ((ViewSetup)viewB.getViewSetup()).getChannel().getName() + ", illum=" + ((ViewSetup)viewB.getViewSetup()).getIllumination().getName() + "]";
                tasks.add(this.pairwiseMatchingInstance(pair, description));
            }
            try {
                taskExecutor.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                IOFunctions.println("Failed to compute registrations for " + subset.getDescription());
                e.printStackTrace();
            }
            int sumCandidates = 0;
            int sumInliers = 0;
            for (PairwiseMatch pair : pairs) {
                sumCandidates += pair.getCandidates().size();
                sumInliers += pair.getInliers().size();
            }
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Number of Candidates: " + sumCandidates);
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Number of Inliers: " + sumInliers);
            if (collectStatistics) {
                this.statistics.add(pairs);
            }
            registrationType.clearExistingCorrespondences(subset);
            registrationType.addCorrespondences(pairs);
            if (save) {
                registrationType.saveCorrespondences(subset);
            }
            if (!this.runGlobalOpt(subset, registrationType)) continue;
            ++successfulRuns;
        }
        return successfulRuns > 0;
    }
}

