/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;

public class ROIBrush_
implements PlugIn {
    public static final String MACRO_CMD = "var roiBrushWidth = 10;\nvar pollDelay = 10;\nvar leftClick=16, altOrShift=9;\nmacro 'Roi Brush Tool - C111o11ff' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  if (flags&altOrShift==0){\n   call('ROIBrush_.label', x,y,z,flags,roiBrushWidth);\n  }else{\n   call('ROIBrush_.unlabel', x,y,z,flags,roiBrushWidth);\n  }\n  wait(pollDelay);\n }\n}\n\nmacro 'Roi Brush Tool Options...' {\n roiBrushWidth = getNumber('Roi Brush Width (pixels):', brushWidth);\n}";

    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.37c")) {
            return;
        }
        MacroInstaller installer = new MacroInstaller();
        installer.install(MACRO_CMD);
    }

    public static void label(String x, String y, String z, String flags, String width) {
        System.out.println("ROIBrush_.label called from a macro at: " + x + "," + y);
        ROIBrush_.label((int)Float.parseFloat(x), (int)Float.parseFloat(y), (int)Float.parseFloat(z), (int)Float.parseFloat(flags), (int)Float.parseFloat(width));
    }

    public static void unlabel(String x, String y, String z, String flags, String width) {
        ROIBrush_.unlabel((int)Float.parseFloat(x), (int)Float.parseFloat(y), (int)Float.parseFloat(z), (int)Float.parseFloat(flags), (int)Float.parseFloat(width));
    }

    public static synchronized void label(int x, int y, int z, int flags, int width) {
        Roi roi = IJ.getImage().getRoi();
        if (roi != null) {
            if (!(roi instanceof ShapeRoi)) {
                roi = new ShapeRoi(roi);
            }
            ShapeRoi roiShape = (ShapeRoi)roi;
            roiShape.or(ROIBrush_.getBrushRoi(x, y, width));
        } else {
            roi = ROIBrush_.getBrushRoi(x, y, width);
        }
        IJ.getImage().setRoi(roi);
    }

    public static synchronized void unlabel(int x, int y, int z, int flags, int width) {
        Roi roi = IJ.getImage().getRoi();
        if (roi != null) {
            if (!(roi instanceof ShapeRoi)) {
                roi = new ShapeRoi(roi);
            }
            ShapeRoi roiShape = (ShapeRoi)roi;
            roiShape.not(ROIBrush_.getBrushRoi(x, y, width));
            IJ.getImage().setRoi(roi);
        }
    }

    private static ShapeRoi getBrushRoi(int x, int y, int width) {
        return new ShapeRoi((Roi)new OvalRoi(x - width / 2, y - width / 2, width, width));
    }
}

