/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.imglib2.Localizable;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.execution.Variable;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;

public class LetBinding<O extends RealType<O>>
implements OFunction<O> {
    private final O scrap;
    private double scrap_value;
    private final String varName;
    private final OFunction<O> varValue;
    private final OFunction<O> body;

    public LetBinding(O scrap, String varName, OFunction<O> varValue, OFunction<O> body) {
        this.scrap = scrap;
        this.varName = varName;
        this.varValue = varValue;
        this.body = body;
    }

    public LetBinding(O scrap, String varName, Map<String, LetBinding<O>> bindings, IFunction varValue, IFunction body, Converter<RealType<?>, O> converter, Map<Variable<O>, OFunction<O>> imgSources) {
        this.scrap = scrap;
        this.varName = varName;
        bindings.put(varName, this);
        this.varValue = varValue.reInit((RealType)scrap.copy(), bindings, converter, imgSources);
        this.body = body.reInit((RealType)scrap.copy(), bindings, converter, imgSources);
    }

    public final O getScrapValue() {
        return this.scrap;
    }

    public final double getDoubleValue() {
        return this.scrap_value;
    }

    @Override
    public final O eval() {
        this.scrap.set(this.varValue.eval());
        return this.body.eval();
    }

    @Override
    public final O eval(Localizable loc) {
        this.scrap.set(this.varValue.eval(loc));
        return this.body.eval(loc);
    }

    public final String getVarName() {
        return this.varName;
    }

    @Override
    public List<OFunction<O>> children() {
        return Arrays.asList(this.varValue, this.body);
    }

    @Override
    public final double evalDouble() {
        this.scrap_value = this.varValue.evalDouble();
        return this.body.evalDouble();
    }

    @Override
    public final double evalDouble(Localizable loc) {
        this.scrap_value = this.varValue.evalDouble(loc);
        return this.body.evalDouble(loc);
    }
}

