/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import math3d.Bookstein;
import math3d.Point3d;
import vib.oldregistration.RegistrationAlgorithm;

public class BooksteinFromLandmarks
extends RegistrationAlgorithm {
    double xSpacingTemplate;
    double xSpacingDomain;
    double ySpacingTemplate;
    double ySpacingDomain;
    double zSpacingTemplate;
    double zSpacingDomain;
    int templateWidth;
    int templateHeight;
    int templateDepth;
    int domainWidth;
    int domainHeight;
    int domainDepth;
    Bookstein templateToDomain;
    Bookstein domainToTemplate;
    Calibration templateCalibration;
    Calibration domainCalibration;
    Point3d p = new Point3d();

    @Override
    public void generateTransformation() {
        NamedPointSet points0 = null;
        NamedPointSet points1 = null;
        try {
            points0 = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException e) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[0].getTitle() + "\"");
        }
        try {
            points1 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException e) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[1].getTitle() + "\"");
        }
        this.generateTransformation(points0, points1);
    }

    public void generateTransformation(NamedPointSet points0, NamedPointSet points1) {
        if (this.sourceImages == null) {
            throw new RuntimeException("Bookstein_From_Landmarks: The source images must be set before calling generateTransformation()");
        }
        if (this.sourceImages[0] == null) {
            throw new RuntimeException("Bookstein_From_Landmarks: The template image is null in generateTransformation()");
        }
        if (this.sourceImages[1] == null) {
            throw new RuntimeException("Bookstein_From_Landmarks: The image to transform is null in generateTransformation()");
        }
        ArrayList<String> commonPointNames = points0.namesSharedWith(points1, true);
        Point3d[] domainPoints = new Point3d[commonPointNames.size()];
        Point3d[] templatePoints = new Point3d[commonPointNames.size()];
        int i_index = 0;
        for (String s : commonPointNames) {
            Point3d p;
            for (NamedPointWorld current : points0.pointsWorld) {
                if (!s.equals(current.getName())) continue;
                templatePoints[i_index] = p = new Point3d(current.x, current.y, current.z);
                break;
            }
            for (NamedPointWorld current : points1.pointsWorld) {
                if (!s.equals(current.getName())) continue;
                domainPoints[i_index] = p = new Point3d(current.x, current.y, current.z);
                break;
            }
            ++i_index;
        }
        this.templateToDomain = new Bookstein(templatePoints, domainPoints);
        ImagePlus template = this.sourceImages[0];
        ImagePlus domain = this.sourceImages[1];
        this.xSpacingTemplate = 1.0;
        this.ySpacingTemplate = 1.0;
        this.zSpacingTemplate = 1.0;
        this.templateCalibration = template.getCalibration();
        if (this.templateCalibration != null) {
            this.xSpacingTemplate = this.templateCalibration.pixelWidth;
            this.ySpacingTemplate = this.templateCalibration.pixelHeight;
            this.zSpacingTemplate = this.templateCalibration.pixelDepth;
        }
        this.xSpacingDomain = 1.0;
        this.ySpacingDomain = 1.0;
        this.zSpacingDomain = 1.0;
        this.domainCalibration = domain.getCalibration();
        if (this.domainCalibration != null) {
            this.xSpacingDomain = this.domainCalibration.pixelWidth;
            this.ySpacingDomain = this.domainCalibration.pixelHeight;
            this.zSpacingDomain = this.domainCalibration.pixelDepth;
        }
        this.templateWidth = template.getWidth();
        this.templateHeight = template.getHeight();
        this.templateDepth = template.getStackSize();
        this.domainWidth = domain.getWidth();
        this.domainHeight = domain.getHeight();
        this.domainDepth = domain.getStackSize();
        this.validateTransformation();
    }

    @Override
    public void transformTemplateToDomainWorld(double x, double y, double z, Point3d result) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transformWorld() with an invalid transformation.");
        }
        this.p.x = x;
        this.p.y = y;
        this.p.z = z;
        this.templateToDomain.apply(this.p);
        result.x = this.templateToDomain.x;
        result.y = this.templateToDomain.y;
        result.z = this.templateToDomain.z;
    }

    @Override
    public void transformTemplateToDomain(int x, int y, int z, RegistrationAlgorithm.ImagePoint result) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transform() with an invalid transformation.");
        }
        this.p.x = (double)x * this.xSpacingTemplate;
        this.p.y = (double)y * this.ySpacingTemplate;
        this.p.z = (double)z * this.zSpacingTemplate;
        this.templateToDomain.apply(this.p);
        double dxd = this.templateToDomain.x / this.xSpacingDomain;
        double dyd = this.templateToDomain.y / this.ySpacingDomain;
        double dzd = this.templateToDomain.z / this.zSpacingDomain;
        result.x = (int)Math.round(dxd);
        result.y = (int)Math.round(dyd);
        result.z = (int)Math.round(dzd);
    }

    @Override
    public void transformDomainToTemplateWorld(double x, double y, double z, Point3d result) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transformWorld() with an invalid transformation.");
        }
        this.p.x = x;
        this.p.y = y;
        this.p.z = z;
        this.domainToTemplate.apply(this.p);
        result.x = this.domainToTemplate.x;
        result.y = this.domainToTemplate.y;
        result.z = this.domainToTemplate.z;
    }

    @Override
    public void transformDomainToTemplate(int x, int y, int z, RegistrationAlgorithm.ImagePoint result) {
        if (!this.isTransformationValid()) {
            throw new RuntimeException("Trying to use Bookstein_From_Landmarks.transform() with an invalid transformation.");
        }
        this.p.x = (double)x * this.xSpacingDomain;
        this.p.y = (double)y * this.ySpacingDomain;
        this.p.z = (double)z * this.zSpacingDomain;
        this.domainToTemplate.apply(this.p);
        double dxd = this.domainToTemplate.x / this.xSpacingTemplate;
        double dyd = this.domainToTemplate.y / this.ySpacingTemplate;
        double dzd = this.domainToTemplate.z / this.zSpacingTemplate;
        result.x = (int)Math.round(dxd);
        result.y = (int)Math.round(dyd);
        result.z = (int)Math.round(dzd);
    }

    @Override
    public ImagePlus register() {
        NamedPointSet points0 = null;
        NamedPointSet points1 = null;
        try {
            points0 = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException e) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[0].getTitle() + "\"");
        }
        try {
            points1 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException e) {
            throw new RuntimeException("No corresponding .points file found for image: \"" + this.sourceImages[1].getTitle() + "\"");
        }
        return this.register(points0, points1);
    }

    @Override
    public ImagePlus register(NamedPointSet points0, NamedPointSet points1) {
        this.generateTransformation(points0, points1);
        ImageStack newStack = new ImageStack(this.templateWidth, this.templateHeight);
        ImageStack domainStack = this.sourceImages[1].getStack();
        byte[][] domainPixels = new byte[this.domainDepth][];
        for (int z = 0; z < this.domainDepth; ++z) {
            domainPixels[z] = (byte[])domainStack.getPixels(z + 1);
        }
        RegistrationAlgorithm.ImagePoint result = new RegistrationAlgorithm.ImagePoint();
        IJ.showProgress((double)0.0);
        for (int z = 0; z < this.templateDepth; ++z) {
            byte[] pixels = new byte[this.templateWidth * this.templateHeight];
            for (int y = 0; y < this.templateHeight; ++y) {
                for (int x = 0; x < this.templateWidth; ++x) {
                    this.transformTemplateToDomain(x, y, z, result);
                    int dx = result.x;
                    int dy = result.y;
                    int dz = result.z;
                    if (dx < 0 || dy < 0 || dz < 0 || dx >= this.domainWidth || dy >= this.domainHeight || dz >= this.domainDepth) continue;
                    pixels[y * this.templateWidth + x] = domainPixels[dz][dy * this.domainWidth + dx];
                }
            }
            ByteProcessor bp = new ByteProcessor(this.templateWidth, this.templateHeight);
            bp.setPixels((Object)pixels);
            newStack.addSlice("", (ImageProcessor)bp);
            IJ.showProgress((double)((double)(z + 1) / (double)this.templateDepth));
        }
        IJ.showProgress((double)1.0);
        ImagePlus transformed = new ImagePlus("Transformed", newStack);
        if (this.templateCalibration != null) {
            transformed.setCalibration(this.templateCalibration);
        }
        return transformed;
    }
}

