/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.UIAdapter;
import ij3d.UniverseSettings;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jogamp.java3d.Background;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.J3DGraphics2D;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.vecmath.Color3f;

public class ImageCanvas3D
extends Canvas3D
implements KeyListener {
    private final RoiImagePlus roiImagePlus;
    private final ImageCanvas roiImageCanvas;
    private Map<Integer, Long> pressed;
    private Map<Integer, Long> released;
    private final Background background;
    private final UIAdapter ui;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();

    protected void flush() {
        this.exec.shutdown();
    }

    public ImageCanvas3D(int width, int height, UIAdapter uia) {
        super(SimpleUniverse.getPreferredConfiguration());
        this.ui = uia;
        this.setPreferredSize(new Dimension(width, height));
        ByteProcessor ip = new ByteProcessor(width, height);
        this.roiImagePlus = new RoiImagePlus("RoiImage", ip);
        this.roiImageCanvas = new ImageCanvas(this.roiImagePlus){

            public void mousePressed(MouseEvent e) {
                if (!ImageCanvas3D.this.ui.isMagnifierTool() && !ImageCanvas3D.this.ui.isPointTool()) {
                    super.mousePressed(e);
                }
            }
        };
        this.roiImageCanvas.removeKeyListener((KeyListener)IJ.getInstance());
        this.roiImageCanvas.removeMouseListener((MouseListener)this.roiImageCanvas);
        this.roiImageCanvas.removeMouseMotionListener((MouseMotionListener)this.roiImageCanvas);
        this.roiImageCanvas.disablePopupMenu(true);
        this.background = new Background(new Color3f(UniverseSettings.defaultBackground));
        this.background.setCapability(17);
        this.addListeners();
    }

    public Background getBG() {
        return this.background;
    }

    public void killRoi() {
        this.roiImagePlus.killRoi();
        this.render();
    }

    void addListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ImageCanvas3D.this.ui.isRoiTool()) {
                    ImageCanvas3D.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            ImageCanvas3D.this.postRender();
                        }
                    });
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ImageCanvas3D.this.ui.isRoiTool()) {
                    ImageCanvas3D.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            ImageCanvas3D.this.render();
                        }
                    });
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ImageCanvas3D.this.ui.isRoiTool()) {
                    ImageCanvas3D.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            ImageCanvas3D.this.render();
                        }
                    });
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ImageCanvas3D.this.ui.isRoiTool()) {
                    ImageCanvas3D.this.roiImagePlus.killRoi();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageCanvas3D.this.exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        ByteProcessor ip = new ByteProcessor(ImageCanvas3D.this.getWidth(), ImageCanvas3D.this.getHeight());
                        ImageCanvas3D.this.roiImagePlus.setProcessor("RoiImagePlus", (ImageProcessor)ip);
                        ImageCanvas3D.this.render();
                    }
                });
            }
        });
    }

    public ImageCanvas getRoiCanvas() {
        return this.roiImageCanvas;
    }

    public Roi getRoi() {
        return this.roiImagePlus.getRoi();
    }

    public void render() {
        this.stopRenderer();
        this.swap();
        this.startRenderer();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        long when = e.getWhen();
        this.pressed.put(e.getKeyCode(), when);
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        long when = e.getWhen();
        this.released.put(e.getKeyCode(), when);
    }

    public synchronized void releaseKey(int keycode) {
        this.pressed.remove(keycode);
        this.released.remove(keycode);
    }

    public synchronized boolean isKeyDown(int keycode) {
        long r;
        if (!this.pressed.containsKey(keycode)) {
            return false;
        }
        if (!this.released.containsKey(keycode)) {
            return true;
        }
        long p = this.pressed.get(keycode);
        return p >= (r = this.released.get(keycode).longValue()) || System.currentTimeMillis() - r < 100L;
    }

    public void postRender() {
        J3DGraphics2D g3d = this.getGraphics2D();
        Roi roi = this.roiImagePlus.getRoi();
        if (roi != null) {
            roi.draw((Graphics)g3d);
        }
        g3d.flush(true);
    }

    private class RoiImagePlus
    extends ImagePlus {
        public RoiImagePlus(String title, ByteProcessor ip) {
            this.setProcessor(title, (ImageProcessor)ip);
            ImageCanvas3D.this.pressed = new HashMap();
            ImageCanvas3D.this.released = new HashMap();
        }

        public ImageCanvas getCanvas() {
            return ImageCanvas3D.this.roiImageCanvas;
        }
    }
}

