/*
 * Decompiled with CFR 0.152.
 */
package ij3d.gui;

import ij.gui.GenericDialog;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

public class LUTDialog
extends GenericDialog {
    private final ArrayList<Listener> listeners = new ArrayList();
    private final Repainter repainter = new Repainter();
    private final ChannelsTool tool;
    private final int[] rOld = new int[256];
    private final int[] gOld = new int[256];
    private final int[] bOld = new int[256];
    private final int[] aOld = new int[256];
    private final int[] r;
    private final int[] g;
    private final int[] b;
    private final int[] a;

    public LUTDialog(int[] r, int[] g, int[] b, int[] a) {
        super("Transfer functions");
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        System.arraycopy(r, 0, this.rOld, 0, 256);
        System.arraycopy(g, 0, this.gOld, 0, 256);
        System.arraycopy(b, 0, this.bOld, 0, 256);
        System.arraycopy(a, 0, this.aOld, 0, 256);
        this.setModal(false);
        this.tool = new ChannelsTool(r, g, b, a);
        this.addPanel(this.tool);
        String[] choice = new String[]{"Red", "Green", "Blue", "Alpha", "RGB", "RGBA"};
        this.addChoice("Channel", choice, choice[0]);
        final Choice cho = (Choice)this.getChoices().get(0);
        cho.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LUTDialog.this.tool.channel = cho.getSelectedIndex();
                LUTDialog.this.tool.repaint();
            }
        });
        Panel p = new Panel(new FlowLayout());
        Button button = new Button("Reset");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LUTDialog.this.reset();
                LUTDialog.this.repainter.requestRepaint();
                LUTDialog.this.tool.repaint();
            }
        });
        p.add(button);
        this.addPanel(p);
        this.repainter.start();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LUTDialog.this.repainter.quit();
            }
        });
    }

    public void addCtrlHint() {
        this.addMessage("Press <Ctrl> to create straight lines");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.reset();
            this.repainter.requestRepaint();
            this.tool.repaint();
        }
        super.actionPerformed(e);
    }

    public void reset() {
        System.arraycopy(this.rOld, 0, this.r, 0, 256);
        System.arraycopy(this.gOld, 0, this.g, 0, 256);
        System.arraycopy(this.bOld, 0, this.b, 0, 256);
        System.arraycopy(this.aOld, 0, this.a, 0, 256);
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireApplied() {
        for (Listener l : this.listeners) {
            l.applied();
        }
    }

    private class ChannelsTool
    extends Panel
    implements MouseListener,
    MouseMotionListener {
        static final int RED = 0;
        static final int GREEN = 1;
        static final int BLUE = 2;
        static final int ALPHA = 3;
        static final int RGB = 4;
        static final int RGBA = 5;
        private final boolean allLuts = false;
        private final int[][] luts;
        private final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.WHITE};
        private int channel = 0;
        int xLast = -1;
        int yLast = -1;

        public ChannelsTool(int[] r, int[] g, int[] b, int[] a) {
            this.setPreferredSize(new Dimension(256, 256));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setBackground(Color.BLACK);
            this.luts = new int[4][];
            this.luts[0] = r;
            this.luts[1] = g;
            this.luts[2] = b;
            this.luts[3] = a;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.xLast = e.getX();
            this.yLast = e.getY();
            this.handleMouseDragged(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handleMouseDragged(e);
        }

        public void handleMouseDragged(MouseEvent e) {
            int mod = e.getModifiers();
            boolean ctrl = (mod & 2) != 0;
            this.handleMouseDraggedWithoutCtrl(e, ctrl);
        }

        public void handleMouseDraggedWithoutCtrl(MouseEvent e, boolean ctrl) {
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x > 255) {
                x = 255;
            }
            if (y > 255) {
                y = 255;
            }
            int sx = this.xLast;
            int ex = x;
            int sy = this.yLast;
            int ey = y;
            if (ex < sx) {
                sx = x;
                ex = this.xLast;
                sy = y;
                ey = this.yLast;
            }
            int lx = ex - sx;
            int ly = ey - sy;
            block5: for (int i = sx; i <= ex; ++i) {
                if (lx == 0) {
                    lx = 1;
                }
                double r = (double)(i - sx) / (double)lx;
                int yi = (int)Math.round((double)sy + r * (double)ly);
                int v = 255 - yi;
                switch (this.channel) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.luts[this.channel][i] = v;
                        continue block5;
                    }
                    case 4: {
                        int n = v;
                        this.luts[2][i] = n;
                        this.luts[1][i] = n;
                        this.luts[0][i] = n;
                        continue block5;
                    }
                    case 5: {
                        int n = v;
                        this.luts[3][i] = n;
                        this.luts[2][i] = n;
                        this.luts[1][i] = n;
                        this.luts[0][i] = n;
                    }
                }
            }
            if (!ctrl) {
                this.yLast = y;
                this.xLast = x;
            }
            this.repaint();
            LUTDialog.this.repainter.requestRepaint();
        }

        @Override
        public void paint(Graphics g) {
            if (this.channel < 4) {
                this.paintLut(g, this.luts[this.channel], this.colors[this.channel]);
                return;
            }
            this.paintLut(g, this.luts[0], this.colors[0]);
            this.paintLut(g, this.luts[1], this.colors[1]);
            this.paintLut(g, this.luts[2], this.colors[2]);
            if (this.channel == 5) {
                this.paintLut(g, this.luts[3], this.colors[3]);
            }
        }

        public void paintLut(Graphics g, int[] lut, Color c) {
            g.setColor(c);
            int x = 0;
            int y = 255 - lut[x];
            for (int i = 1; i < 256; ++i) {
                g.drawLine(x, y, i, 255 - lut[i]);
                x = i;
                y = 255 - lut[i];
            }
        }
    }

    private class Repainter
    extends Thread {
        boolean repaintNeeded = false;
        boolean stop = false;

        private Repainter() {
        }

        public synchronized void requestRepaint() {
            if (!this.repaintNeeded) {
                this.repaintNeeded = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaintIfNeeded() {
            Repainter repainter = this;
            synchronized (repainter) {
                if (!this.repaintNeeded) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.repaintNeeded = false;
                }
            }
            LUTDialog.this.fireApplied();
        }

        public void quit() {
            this.stop = true;
            this.requestRepaint();
        }

        @Override
        public void run() {
            while (!this.stop) {
                this.repaintIfNeeded();
            }
        }
    }

    public static interface Listener {
        public void applied();
    }
}

