/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shapes;

import java.awt.Font;
import java.text.DecimalFormat;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Font3D;
import org.jogamp.java3d.FontExtrusion;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.OrientedShape3D;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Text3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class Scalebar
extends BranchGroup {
    private final DecimalFormat df = new DecimalFormat("###0.00");
    private float length = 1.0f;
    private Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    private float x = 2.0f;
    private float y = 2.0f;
    private String unit = "";
    private final TransformGroup positionTG;
    private final TransformGroup textTG;
    private final Shape3D lineShape;
    private final OrientedShape3D textShape;

    public Scalebar() {
        this(1.0f);
    }

    public Scalebar(float length) {
        Transform3D position = new Transform3D();
        this.positionTG = new TransformGroup(position);
        this.positionTG.setCapability(17);
        this.positionTG.setCapability(18);
        this.addChild((Node)this.positionTG);
        this.lineShape = new Shape3D();
        this.lineShape.setGeometry(this.createLineGeometry());
        this.lineShape.setCapability(13);
        this.positionTG.addChild((Node)this.lineShape);
        Transform3D texttranslate = new Transform3D();
        texttranslate.setTranslation(new Vector3f(length / 2.0f, -length / 2.0f, 0.0f));
        this.textTG = new TransformGroup(texttranslate);
        this.textTG.setCapability(18);
        this.positionTG.addChild((Node)this.textTG);
        this.textShape = new OrientedShape3D();
        this.textShape.setCapability(13);
        this.textShape.setCapability(15);
        this.textShape.setGeometry(this.createTextGeometry());
        this.textShape.setAppearance(this.createTextAppearance());
        this.textShape.setAlignmentAxis(0.0f, 1.0f, 0.0f);
        this.textTG.addChild((Node)this.textShape);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getLength() {
        return this.length;
    }

    public String getUnit() {
        return this.unit;
    }

    public Color3f getColor() {
        return this.color;
    }

    public void setUnit(String unit) {
        this.unit = unit;
        this.textShape.setGeometry(this.createTextGeometry());
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        Transform3D p = new Transform3D();
        p.setTranslation(new Vector3f(x, y, 0.0f));
        this.positionTG.setTransform(p);
    }

    public void setLength(float l) {
        this.length = l;
        this.lineShape.setGeometry(this.createLineGeometry());
        this.textShape.setGeometry(this.createTextGeometry());
        Transform3D d = new Transform3D();
        d.setTranslation(new Vector3f(this.length / 2.0f, -this.length / 2.0f, 0.0f));
        this.textTG.setTransform(d);
    }

    public void setColor(Color3f c) {
        this.color = c;
        this.lineShape.setGeometry(this.createLineGeometry());
        this.textShape.setAppearance(this.createTextAppearance());
    }

    public Appearance createTextAppearance() {
        Appearance textAppear = new Appearance();
        ColoringAttributes textColor = new ColoringAttributes();
        textColor.setColor(this.color);
        textAppear.setColoringAttributes(textColor);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        pa.setBackFaceNormalFlip(true);
        textAppear.setPolygonAttributes(pa);
        return textAppear;
    }

    public Geometry createTextGeometry() {
        String text = this.df.format(this.length) + " " + this.unit;
        int fontSize = (int)this.length / 3;
        Font3D font3D = new Font3D(new Font("Helvetica", 0, fontSize > 0 ? fontSize : 1), new FontExtrusion());
        try {
            Text3D textGeom = new Text3D(font3D, text);
            textGeom.setAlignment(0);
            return textGeom;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Geometry createLineGeometry() {
        Point3f origin = new Point3f();
        Point3f onX = new Point3f(this.length < 1.0f ? 1.0f : this.length, 0.0f, 0.0f);
        Point3f[] coords = new Point3f[]{origin, onX};
        int N = coords.length;
        Color3f[] colors = new Color3f[N];
        for (int i = 0; i < N; ++i) {
            colors[i] = this.color;
        }
        LineArray ta = new LineArray(N, 5);
        ta.setCoordinates(0, coords);
        ta.setColors(0, colors);
        return ta;
    }
}

