/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.imglib2.Sampler;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.loops.ListUtils;
import net.imglib2.loops.LoopBuilder;

final class BindActionToSamplers {
    private static final List<ClassCopyProvider<Runnable>> factories = Arrays.asList(new ClassCopyProvider<Runnable>(ConsumerRunnable.class, Runnable.class, new Class[0]), new ClassCopyProvider<Runnable>(BiConsumerRunnable.class, Runnable.class, new Class[0]), new ClassCopyProvider<Runnable>(TriConsumerRunnable.class, Runnable.class, new Class[0]), new ClassCopyProvider<Runnable>(FourConsumerRunnable.class, Runnable.class, new Class[0]), new ClassCopyProvider<Runnable>(FiveConsumerRunnable.class, Runnable.class, new Class[0]), new ClassCopyProvider<Runnable>(SixConsumerRunnable.class, Runnable.class, new Class[0]));

    BindActionToSamplers() {
    }

    public static Runnable bindActionToSamplers(Object action, List<? extends Sampler<?>> samplers) {
        Object[] arguments = ListUtils.concatAsArray(action, samplers);
        ClassCopyProvider<Runnable> factory = factories.get(samplers.size() - 1);
        List<Class> key = ListUtils.map(Object::getClass, arguments);
        return factory.newInstanceForKey(key, arguments);
    }

    public static class SixConsumerRunnable<A, B, C, D, E, F>
    implements Runnable {
        private final LoopBuilder.SixConsumer<A, B, C, D, E, F> action;
        private final Sampler<A> samplerA;
        private final Sampler<B> samplerB;
        private final Sampler<C> samplerC;
        private final Sampler<D> samplerD;
        private final Sampler<E> samplerE;
        private final Sampler<F> samplerF;

        public SixConsumerRunnable(LoopBuilder.SixConsumer<A, B, C, D, E, F> action, Sampler<A> samplerA, Sampler<B> samplerB, Sampler<C> samplerC, Sampler<D> samplerD, Sampler<E> samplerE, Sampler<F> samplerF) {
            this.action = action;
            this.samplerA = samplerA;
            this.samplerB = samplerB;
            this.samplerC = samplerC;
            this.samplerD = samplerD;
            this.samplerE = samplerE;
            this.samplerF = samplerF;
        }

        @Override
        public void run() {
            this.action.accept(this.samplerA.get(), this.samplerB.get(), this.samplerC.get(), this.samplerD.get(), this.samplerE.get(), this.samplerF.get());
        }
    }

    public static class FiveConsumerRunnable<A, B, C, D, E>
    implements Runnable {
        private final LoopBuilder.FiveConsumer<A, B, C, D, E> action;
        private final Sampler<A> samplerA;
        private final Sampler<B> samplerB;
        private final Sampler<C> samplerC;
        private final Sampler<D> samplerD;
        private final Sampler<E> samplerE;

        public FiveConsumerRunnable(LoopBuilder.FiveConsumer<A, B, C, D, E> action, Sampler<A> samplerA, Sampler<B> samplerB, Sampler<C> samplerC, Sampler<D> samplerD, Sampler<E> samplerE) {
            this.action = action;
            this.samplerA = samplerA;
            this.samplerB = samplerB;
            this.samplerC = samplerC;
            this.samplerD = samplerD;
            this.samplerE = samplerE;
        }

        @Override
        public void run() {
            this.action.accept(this.samplerA.get(), this.samplerB.get(), this.samplerC.get(), this.samplerD.get(), this.samplerE.get());
        }
    }

    public static class FourConsumerRunnable<A, B, C, D>
    implements Runnable {
        private final LoopBuilder.FourConsumer<A, B, C, D> action;
        private final Sampler<A> samplerA;
        private final Sampler<B> samplerB;
        private final Sampler<C> samplerC;
        private final Sampler<D> samplerD;

        public FourConsumerRunnable(LoopBuilder.FourConsumer<A, B, C, D> action, Sampler<A> samplerA, Sampler<B> samplerB, Sampler<C> samplerC, Sampler<D> samplerD) {
            this.action = action;
            this.samplerA = samplerA;
            this.samplerB = samplerB;
            this.samplerC = samplerC;
            this.samplerD = samplerD;
        }

        @Override
        public void run() {
            this.action.accept(this.samplerA.get(), this.samplerB.get(), this.samplerC.get(), this.samplerD.get());
        }
    }

    public static class TriConsumerRunnable<A, B, C>
    implements Runnable {
        private final LoopBuilder.TriConsumer<A, B, C> action;
        private final Sampler<A> samplerA;
        private final Sampler<B> samplerB;
        private final Sampler<C> samplerC;

        public TriConsumerRunnable(LoopBuilder.TriConsumer<A, B, C> action, Sampler<A> samplerA, Sampler<B> samplerB, Sampler<C> samplerC) {
            this.action = action;
            this.samplerA = samplerA;
            this.samplerB = samplerB;
            this.samplerC = samplerC;
        }

        @Override
        public void run() {
            this.action.accept(this.samplerA.get(), this.samplerB.get(), this.samplerC.get());
        }
    }

    public static class BiConsumerRunnable<A, B>
    implements Runnable {
        private final BiConsumer<A, B> action;
        private final Sampler<A> samplerA;
        private final Sampler<B> samplerB;

        public BiConsumerRunnable(BiConsumer<A, B> action, Sampler<A> samplerA, Sampler<B> samplerB) {
            this.action = action;
            this.samplerA = samplerA;
            this.samplerB = samplerB;
        }

        @Override
        public void run() {
            this.action.accept(this.samplerA.get(), this.samplerB.get());
        }
    }

    public static class ConsumerRunnable<A>
    implements Runnable {
        private final Consumer<A> action;
        private final Sampler<A> samplerA;

        public ConsumerRunnable(Consumer<A> action, Sampler<A> samplerA) {
            this.action = action;
            this.samplerA = samplerA;
        }

        @Override
        public void run() {
            this.action.accept(this.samplerA.get());
        }
    }
}

