/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer.permutation;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.transform.integer.permutation.AbstractPermutationTransform;

public class PermutationTransform
extends AbstractPermutationTransform {
    protected final int numSourceDimensions;
    protected final int numTargetDimensions;

    public PermutationTransform(int[] lut, int numSourceDimensions, int numTargetDimensions) {
        super(lut);
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = numTargetDimensions;
    }

    @Override
    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    @Override
    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    @Override
    public void apply(long[] source, long[] target) {
        assert (source.length >= this.numTargetDimensions && target.length >= this.numTargetDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = this.apply((int)source[d]);
        }
    }

    @Override
    public void apply(int[] source, int[] target) {
        assert (source.length >= this.numTargetDimensions && target.length >= this.numTargetDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = this.apply(this.lut[source[d]]);
        }
    }

    @Override
    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.numTargetDimensions && target.numDimensions() >= this.numTargetDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target.setPosition(this.apply(source.getIntPosition(d)), d);
        }
    }

    @Override
    public void applyInverse(long[] source, long[] target) {
        assert (source.length >= this.numSourceDimensions && target.length >= this.numSourceDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numSourceDimensions; ++d) {
            source[d] = this.applyInverse((int)target[d]);
        }
    }

    @Override
    public void applyInverse(int[] source, int[] target) {
        assert (source.length >= this.numSourceDimensions && target.length >= this.numSourceDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numSourceDimensions; ++d) {
            source[d] = this.applyInverse(target[d]);
        }
    }

    @Override
    public void applyInverse(Positionable source, Localizable target) {
        assert (source.numDimensions() >= this.numSourceDimensions && target.numDimensions() >= this.numSourceDimensions) : "Dimensions do not match.";
        for (int d = 0; d < this.numSourceDimensions; ++d) {
            source.setPosition(this.applyInverse(target.getIntPosition(d)), d);
        }
    }

    @Override
    public PermutationTransform inverse() {
        return new PermutationTransform(this.inverseLut, this.numTargetDimensions, this.numSourceDimensions);
    }

    public static boolean checkInterval(Interval interval, int[] lut) {
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.min(d) == 0L && interval.dimension(d) == (long)lut.length) continue;
            return false;
        }
        return true;
    }
}

