/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerBitType;

public class Unsigned2BitType
extends AbstractIntegerBitType<Unsigned2BitType> {
    private static final long mask = 3L;
    private static final NativeTypeFactory<Unsigned2BitType, LongAccess> typeFactory = NativeTypeFactory.LONG(Unsigned2BitType::new);

    public Unsigned2BitType(NativeImg<?, ? extends LongAccess> bitStorage) {
        super(bitStorage, 2);
    }

    public Unsigned2BitType(long value) {
        this((NativeImg)null);
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public Unsigned2BitType(LongAccess access) {
        this((NativeImg)null);
        this.dataAccess = access;
    }

    public Unsigned2BitType() {
        this(0L);
    }

    @Override
    public Unsigned2BitType duplicateTypeOnSameNativeImg() {
        return new Unsigned2BitType(this.img);
    }

    @Override
    public NativeTypeFactory<Unsigned2BitType, LongAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public long get() {
        long j = this.i.get();
        return this.dataAccess.getValue((int)(j >>> 5)) >>> (int)((j & 0x1FL) << 1) & 3L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long value) {
        long j = this.i.get();
        int i1 = (int)(j >>> 5);
        long shift = j << 1 & 0x3FL;
        long bitsToRetain = 3L << (int)shift ^ 0xFFFFFFFFFFFFFFFFL;
        long bitsToSet = (value & 3L) << (int)shift;
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) & bitsToRetain | bitsToSet);
        }
    }

    @Override
    public Unsigned2BitType createVariable() {
        return new Unsigned2BitType(0L);
    }

    @Override
    public Unsigned2BitType copy() {
        return new Unsigned2BitType(this.dataAccess != null ? this.get() : 0L);
    }
}

