/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.TreeMap;
import org.ojalgo.ProgrammingError;

public final class ResourceLocator {
    public static final CookieManager DEFAULT_COOKIE_MANAGER = new CookieManager();
    private CookieHandler myCookieHandler = DEFAULT_COOKIE_MANAGER;
    private String myFragment = null;
    private final String myHost;
    private String myPath = "";
    private int myPort = -1;
    private final Map<String, String> myQueryParameters = new TreeMap<String, String>();
    private String myScheme = "https";

    public ResourceLocator(String host) {
        this.myHost = host;
    }

    public ResourceLocator cookies(CookieHandler cookieHandler) {
        this.myCookieHandler = cookieHandler;
        return this;
    }

    public ResourceLocator fragment(String fragment) {
        this.myFragment = fragment;
        return this;
    }

    public InputStream getInputStream() {
        URLConnection connection = this.openConnection();
        InputStream stream = null;
        try {
            stream = connection.getInputStream();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return stream;
    }

    public Reader getStreamReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public URLConnection openConnection() {
        CookieHandler.setDefault(this.myCookieHandler);
        URL url = this.toURL();
        URLConnection connection = null;
        try {
            connection = url.openConnection();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return connection;
    }

    public ResourceLocator parameter(String key, String value) {
        ProgrammingError.throwIfNull((Object)key, (Object)value);
        this.myQueryParameters.put(key, value);
        return this;
    }

    public Map<String, String> parameters() {
        return this.myQueryParameters;
    }

    public ResourceLocator path(String path) {
        ProgrammingError.throwIfNull((Object)path);
        this.myPath = path;
        return this;
    }

    public ResourceLocator port(int port) {
        this.myPort = port;
        return this;
    }

    public ResourceLocator scheme(String scheme) {
        this.myScheme = scheme;
        return this;
    }

    public String toString() {
        return this.toURL().toString();
    }

    private String query() {
        if (this.myQueryParameters.size() >= 1) {
            StringBuilder retVal = new StringBuilder();
            for (Map.Entry<String, String> tmpEntry : this.myQueryParameters.entrySet()) {
                retVal.append(tmpEntry.getKey());
                retVal.append('=');
                retVal.append(tmpEntry.getValue());
                retVal.append('&');
            }
            retVal.setLength(retVal.length() - 1);
            return retVal.toString();
        }
        return null;
    }

    URL toURL() {
        try {
            URI uri = new URI(this.myScheme, null, this.myHost, this.myPort, this.myPath, this.query(), this.myFragment);
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException xcptn) {
            throw new ProgrammingError(xcptn);
        }
    }
}

