/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ini.trakem2.utils.Utils;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;

public final class ReconstructArea {
    private final GeneralPath gp = new GeneralPath(0);

    public final void add(String svg_path) {
        svg_path = svg_path.trim();
        while (-1 != svg_path.indexOf("  ")) {
            svg_path = svg_path.replaceAll("  ", " ");
        }
        char[] data = new char[svg_path.length()];
        svg_path.getChars(0, data.length, data, 0);
        ReconstructArea.parse(this.gp, data);
    }

    public final Area getArea() {
        return new Area(this.gp);
    }

    public final GeneralPath getGeneralPath() {
        return this.gp;
    }

    private static final void parse(GeneralPath gp, char[] data) {
        if ('z' != data[data.length - 1]) {
            Utils.log("AreaList: no closing z, ignoring sub path");
            return;
        }
        data[data.length - 1] = 76;
        float[] xy = new float[2];
        int i_L = -1;
        for (int i = 0; i < data.length; ++i) {
            if ('L' != data[i]) continue;
            i_L = i;
            break;
        }
        ReconstructArea.readXY(data, i_L, xy);
        gp.moveTo(xy[0], xy[1]);
        int first = i_L + 1;
        while (-1 != (first = ReconstructArea.readXY(data, first, xy))) {
            gp.lineTo(xy[0], xy[1]);
        }
        gp.closePath();
    }

    public static final int readXY(char[] data, int first, float[] xy) {
        if (first >= data.length) {
            return -1;
        }
        int last = first;
        char c = data[first];
        while ('L' != c) {
            if (data.length == ++last) {
                return -1;
            }
            c = data[last];
        }
        first = last + 2;
        if ((last -= 2) < 0) {
            return -1;
        }
        c = data[last];
        xy[1] = 0.0f;
        int pos = 1;
        while (' ' != c) {
            --last;
            if ('-' == c) {
                xy[1] = xy[1] * -1.0f;
                break;
            }
            if ('.' == c) {
                xy[1] = xy[1] / (float)pos;
                pos = 1;
            } else {
                xy[1] = xy[1] + (float)((c - 48) * pos);
                pos *= 10;
            }
            c = data[last];
        }
        c = data[--last];
        pos = 1;
        xy[0] = 0.0f;
        while (' ' != c) {
            --last;
            if ('-' == c) {
                xy[0] = xy[0] * -1.0f;
                break;
            }
            if ('.' == c) {
                xy[0] = xy[0] / (float)pos;
                pos = 1;
            } else {
                xy[0] = xy[0] + (float)((c - 48) * pos);
                pos *= 10;
            }
            c = data[last];
        }
        return first;
    }
}

