/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.IJ;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Profile;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class Render {
    private HashMap<String, Ob> ht_objects = new HashMap();
    private ArrayList<Pipe> al_pipes = new ArrayList();
    private ArrayList<Ball> al_balls = new ArrayList();
    private int counter = 0;

    public Render(Thing thing) {
        this.render(thing);
    }

    public void render(Thing thing) {
        if (thing.getType().equals("profile_list")) {
            this.renderObject(thing);
        } else if (thing.getType().equals("pipe")) {
            this.al_pipes.add((Pipe)thing.getObject());
        } else if (thing.getType().equals("ball")) {
            this.al_balls.add((Ball)thing.getObject());
        }
        if (null == thing.getChildren()) {
            return;
        }
        for (Thing thing2 : thing.getChildren()) {
            if (thing2.getType().equals("profile_list")) {
                this.renderObject(thing2);
                continue;
            }
            if (thing2.getType().equals("pipe")) {
                this.al_pipes.add((Pipe)thing2.getObject());
                continue;
            }
            if (thing2.getType().equals("ball")) {
                this.al_balls.add((Ball)thing2.getObject());
                continue;
            }
            this.render(thing2);
        }
    }

    private void renderObject(Thing profile_list) {
        if (!profile_list.getType().equals("profile_list")) {
            return;
        }
        ArrayList<? extends Thing> al = profile_list.getChildren();
        if (null == al || al.size() < 2) {
            return;
        }
        HashSet<Profile> hs = new HashSet<Profile>();
        for (Thing thing : al) {
            Object ob = thing.getObject();
            if (ob instanceof Profile) {
                hs.add((Profile)ob);
                continue;
            }
            Utils.log2("Render: skipping non Profile class child");
        }
        String name = profile_list.getParent().getTitle();
        ArrayList<String> arrayList = new ArrayList<String>();
        String name2 = name;
        int k = 1;
        while (this.ht_objects.containsKey(name2)) {
            name2 = name + "-" + k;
            ++k;
        }
        name = name2;
        arrayList.add(name);
        this.renderSubObjects(hs, arrayList);
    }

    private Profile accumulate(HashSet<Profile> hs_done, ArrayList<Profile> al, Profile step, int z_trend) {
        HashSet<Displayable> hs_linked = step.getLinked(Profile.class);
        if (al.size() > 1 && hs_linked.size() > 2) {
            return step;
        }
        double step_z = step.getLayer().getZ();
        Profile next_step = null;
        boolean started = false;
        for (Displayable ob : hs_linked) {
            if (al.contains(ob) || started || hs_done.contains(ob)) continue;
            started = true;
            next_step = (Profile)ob;
            double next_z = next_step.getLayer().getZ();
            if (0 == z_trend) {
                z_trend = next_z > step_z ? 1 : -1;
                al.add(next_step);
                continue;
            }
            if (next_z > step_z && 1 == z_trend || next_z < step_z && -1 == z_trend) {
                al.add(next_step);
                continue;
            }
            next_step = null;
        }
        Profile last = step;
        if (null != next_step) {
            hs_done.add(next_step);
            last = this.accumulate(hs_done, al, next_step, z_trend);
        }
        return last;
    }

    private void renderSubObjects(HashSet<Profile> hs_all, ArrayList<String> al_used_names) {
        int size = hs_all.size();
        Profile[] p = new Profile[size];
        hs_all.toArray(p);
        HashSet<Profile> hs_bases = new HashSet<Profile>();
        HashSet<Profile> hs_done = new HashSet<Profile>();
        do {
            Profile base = null;
            if (hs_bases.size() > 0) {
                base = (Profile)hs_bases.iterator().next();
            } else {
                double min_z = Double.MAX_VALUE;
                for (int i = 0; i < p.length; ++i) {
                    double z;
                    if (hs_done.contains(p[i]) || !((z = p[i].getLayer().getZ()) < min_z)) continue;
                    min_z = z;
                    base = p[i];
                }
                if (null != base) {
                    hs_bases.add(base);
                }
            }
            if (null == base) {
                Utils.log2("No more bases.");
                return;
            }
            ArrayList<Profile> al_profiles = new ArrayList<Profile>();
            al_profiles.add(base);
            Profile last = this.accumulate(hs_done, al_profiles, base, 0);
            if (last != base) {
                String name;
                hs_done.addAll(al_profiles);
                hs_bases.add(last);
                Profile[] profiles = new Profile[al_profiles.size()];
                al_profiles.toArray(profiles);
                String name2 = name = this.createName(al_used_names);
                int k = 1;
                while (this.ht_objects.containsKey(name2)) {
                    name2 = name + "_" + k;
                }
                name = name2;
                al_used_names.add(name);
                this.ht_objects.put(name, new Ob(name, profiles));
                ++this.counter;
                Utils.log("count: " + this.counter + " vs " + this.ht_objects.size());
                continue;
            }
            hs_bases.remove(base);
        } while (0 != hs_bases.size());
    }

    private String createName(ArrayList<String> al_used_names) {
        Object[] s = new String[al_used_names.size()];
        al_used_names.toArray(s);
        if (1 == s.length) {
            return s[0];
        }
        Arrays.sort(s);
        Object last = s[s.length - 1];
        int i_us = ((String)last).lastIndexOf(95);
        if (-1 != i_us) {
            for (int i = i_us + 1; i < ((String)last).length(); ++i) {
                if (Character.isDigit(((String)last).charAt(i))) continue;
                return (String)last + "_1";
            }
            return ((String)last).substring(0, i_us + 1) + (Integer.parseInt(((String)last).substring(i_us + 1)) + 1);
        }
        return (String)last + "_1";
    }

    public void save(double z_scale) {
        YesNoCancelDialog d;
        Color colorRGB;
        int i;
        int i2;
        if (this.ht_objects.isEmpty() && this.al_pipes.isEmpty() && this.al_balls.isEmpty()) {
            Utils.log("No objects to save.");
            return;
        }
        Ob[] obs = new Ob[this.ht_objects.size()];
        this.ht_objects.values().toArray(obs);
        Pipe[] pipes = new Pipe[this.al_pipes.size()];
        this.al_pipes.toArray(pipes);
        Ball[] balls = new Ball[this.al_balls.size()];
        this.al_balls.toArray(balls);
        StringBuffer data = new StringBuffer("Groups=");
        String l = "\n";
        for (i2 = 0; i2 < obs.length; ++i2) {
            data.append(obs[i2].name).append(",");
        }
        for (i2 = 0; i2 < pipes.length; ++i2) {
            data.append(pipes[i2].toString()).append(",");
        }
        for (i2 = 0; i2 < balls.length; ++i2) {
            data.append(balls[i2].toString()).append(",");
        }
        int[] color = new int[obs.length + pipes.length + balls.length];
        data.append(l).append("Colors=");
        int j = 0;
        for (i = 0; i < obs.length; ++i) {
            colorRGB = obs[i].profiles[0].getColor();
            color[j++] = colorRGB.getGreen();
            data.append(color[i]).append(",");
        }
        for (i = 0; i < pipes.length; ++i) {
            colorRGB = pipes[i].getColor();
            color[j++] = colorRGB.getGreen();
            data.append(color[i]).append(",");
        }
        for (i = 0; i < balls.length; ++i) {
            colorRGB = balls[i].getColor();
            color[j++] = colorRGB.getGreen();
            data.append(color[i]).append(",");
        }
        data.append(l).append("Supergroups=");
        for (i = 0; i < obs.length + pipes.length + balls.length; ++i) {
            data.append("null,");
        }
        data.append(l).append("Supercolors=");
        for (i = 0; i < obs.length + pipes.length + balls.length; ++i) {
            data.append("null,");
        }
        data.append(l).append(l);
        j = 0;
        for (i = 0; i < obs.length; ++i) {
            String clr = Integer.toString(color[j++]);
            for (int k = 0; k < obs[i].profiles.length; ++k) {
                if (null == obs[i] || null == obs[i].profiles[k]) {
                    Utils.log("obs[i] is : " + obs[i]);
                    if (null == obs[i].profiles[k]) continue;
                    Utils.log("obs[i].profiles[k] is " + obs[i].profiles[k]);
                    continue;
                }
                obs[i].profiles[k].toShapesFile(data, obs[i].name, clr, z_scale);
                data.append(l);
            }
        }
        for (i = 0; i < pipes.length; ++i) {
            pipes[i].toShapesFile(data, pipes[i].toString(), Integer.toString(color[j++]), z_scale);
            data.append(l);
        }
        for (i = 0; i < balls.length; ++i) {
            balls[i].toShapesFile(data, balls[i].toString(), Integer.toString(color[j++]), z_scale);
            data.append(l);
        }
        SaveDialog sd = new SaveDialog("Save .shapes", OpenDialog.getDefaultDirectory(), "shapes");
        String dir = sd.getDirectory();
        if (null == dir) {
            return;
        }
        if (IJ.isWindows()) {
            dir = dir.replace('\\', '/');
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        String file_name = sd.getFileName();
        String file_path = dir + file_name;
        File f = new File(file_path);
        if (f.exists() && !(d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Overwrite?", "File " + file_name + " exists! Overwrite?")).yesPressed()) {
            return;
        }
        String contents = data.toString();
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f), data.length()));
            dos.writeBytes(contents);
            dos.flush();
        }
        catch (Exception e) {
            IJError.print(e);
            Utils.log("ERROR: Most likely did NOT save your file.");
        }
    }

    public static void exportSVG(ProjectThing thing, double z_scale) {
        YesNoCancelDialog d;
        StringBuffer data = new StringBuffer();
        data.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n").append("<svg\n").append("\txmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n").append("\txmlns:cc=\"http://web.resource.org/cc/\"\n").append("\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n").append("\txmlns:svg=\"http://www.w3.org/2000/svg\"\n").append("\txmlns=\"http://www.w3.org/2000/svg\"\n").append("\tid=\"").append(thing.getProject().toString()).append("\">\n");
        thing.exportSVG(data, z_scale, "\t");
        data.append("</svg>");
        SaveDialog sd = new SaveDialog("Save .svg", OpenDialog.getDefaultDirectory(), "svg");
        String dir = sd.getDirectory();
        if (null == dir) {
            return;
        }
        if (IJ.isWindows()) {
            dir = dir.replace('\\', '/');
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        String file_name = sd.getFileName();
        String file_path = dir + file_name;
        File f = new File(file_path);
        if (f.exists() && !(d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Overwrite?", "File " + file_name + " exists! Overwrite?")).yesPressed()) {
            return;
        }
        String contents = data.toString();
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f), data.length()));
            dos.writeBytes(contents);
            dos.flush();
        }
        catch (Exception e) {
            IJError.print(e);
            Utils.log("ERROR: Most likely did NOT save your file.");
        }
    }

    private class Ob {
        String name;
        Profile[] profiles;

        Ob(String name, Profile[] profiles) {
            this.name = name;
            this.profiles = profiles;
        }
    }
}

