/*
 * Decompiled with CFR 0.152.
 */
package mpi.fruitfly.general;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Point;
import mpi.fruitfly.math.General;
import mpi.fruitfly.math.datastructures.FloatArray;
import mpi.fruitfly.math.datastructures.FloatArray2D;
import mpi.fruitfly.math.datastructures.FloatArray3D;
import mpi.fruitfly.math.datastructures.FloatArray4D;

public class ImageArrayConverter {
    public static boolean CUTOFF_VALUES = true;
    public static boolean NORM_VALUES = false;
    public static int DRAWTYPE_OVERLAP = 0;
    public static int DRAWTYPE_ERRORMAP = 1;

    public static ImagePlus FloatArrayToImagePlus(FloatArray2D image, String name, float min, float max) {
        ImagePlus imp = IJ.createImage((String)name, (String)"32-Bit Black", (int)image.width, (int)image.height, (int)1);
        FloatProcessor ip = (FloatProcessor)imp.getProcessor();
        ImageArrayConverter.FloatArrayToFloatProcessor((ImageProcessor)ip, image);
        if (min == max) {
            ip.resetMinAndMax();
        } else {
            ip.setMinAndMax((double)min, (double)max);
        }
        imp.updateAndDraw();
        return imp;
    }

    public static ImagePlus FloatArrayToStack(FloatArray3D image, String name, float min, float max) {
        int width = image.width;
        int height = image.height;
        int nstacks = image.depth;
        ImageStack stack = new ImageStack(width, height);
        for (int slice = 0; slice < nstacks; ++slice) {
            ImagePlus impResult = IJ.createImage((String)"Result", (String)"32-Bit Black", (int)width, (int)height, (int)1);
            ImageProcessor ipResult = impResult.getProcessor();
            float[] sliceImg = new float[width * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    sliceImg[y * width + x] = image.get(x, y, slice);
                }
            }
            ipResult.setPixels((Object)sliceImg);
            if (min == max) {
                ipResult.resetMinAndMax();
            } else {
                ipResult.setMinAndMax((double)min, (double)max);
            }
            stack.addSlice("Slice " + slice, ipResult);
        }
        return new ImagePlus(name, stack);
    }

    public static ImagePlus DoubleArrayToStack(double[] image, int width, int height, int nstacks, String name, float min, float max) {
        ImageStack stack = new ImageStack(width, height);
        for (int slice = 0; slice < nstacks; ++slice) {
            ImagePlus impResult = IJ.createImage((String)"Result", (String)"32-Bit Black", (int)width, (int)height, (int)1);
            ImageProcessor ipResult = impResult.getProcessor();
            float[] sliceImg = new float[width * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    sliceImg[y * width + x] = (float)image[x + width * (y + slice * height)];
                }
            }
            ipResult.setPixels((Object)sliceImg);
            if (min == max) {
                ipResult.resetMinAndMax();
            } else {
                ipResult.setMinAndMax((double)min, (double)max);
            }
            stack.addSlice("Slice " + slice, ipResult);
        }
        return new ImagePlus(name, stack);
    }

    public static FloatArray3D StackToFloatArrayZeroPadding(ImageStack stack, int wZP, int hZP, int dZP) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        int offsetX = (wZP - width) / 2;
        int offsetY = (hZP - height) / 2;
        int offsetZ = (dZP - nstacks) / 2;
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            System.out.println("RGB images supported at the moment.");
            return null;
        }
        FloatArray3D pixels = new FloatArray3D(wZP, hZP, dZP);
        int stepY = pixels.getPos(0, 1, 0) - width;
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                int pos = pixels.getPos(offsetX, offsetY, offsetZ + countSlice);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pos++] = pixelTmp[count++] & 0xFF;
                    }
                    pos += stepY;
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                int pos = pixels.getPos(offsetX, offsetY, offsetZ + countSlice);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pos++] = pixelTmp[count++] & 0xFFFF;
                    }
                    pos += stepY;
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                int pos = pixels.getPos(offsetX, offsetY, offsetZ + countSlice);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pos++] = pixelTmp[count++];
                    }
                    pos += stepY;
                }
            }
        }
        return pixels;
    }

    public static FloatArray4D StackToFloatArrayComplexZeroPadding(ImageStack stack, int wZP, int hZP, int dZP) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        int offsetX = (wZP - width) / 2;
        int offsetY = (hZP - height) / 2;
        int offsetZ = (dZP - nstacks) / 2;
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            System.out.println("RGB images supported at the moment.");
            return null;
        }
        FloatArray4D pixels = new FloatArray4D(wZP, hZP, dZP, 2);
        int stepY = pixels.getPos(0, 1, 0, 0) - width;
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                int pos = pixels.getPos(offsetX, offsetY, offsetZ + countSlice, 0);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pos++] = pixelTmp[count++] & 0xFF;
                    }
                    pos += stepY;
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                int pos = pixels.getPos(offsetX, offsetY, offsetZ + countSlice, 0);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pos++] = pixelTmp[count++] & 0xFFFF;
                    }
                    pos += stepY;
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                int pos = pixels.getPos(offsetX, offsetY, offsetZ + countSlice, 0);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pos++] = pixelTmp[count++];
                    }
                    pos += stepY;
                }
            }
        }
        return pixels;
    }

    public static double[] StackToDoubleArrayZeroPadding(ImageStack stack, int wZP, int hZP, int dZP) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        int offsetX = (wZP - width) / 2;
        int offsetY = (hZP - height) / 2;
        int offsetZ = (dZP - nstacks) / 2;
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            System.out.println("RGB images supported at the moment.");
            return null;
        }
        double[] pixels = new double[wZP * hZP * dZP];
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x + offsetX + width * (y + offsetY + (countSlice + offsetZ) * height)] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x + offsetX + width * (y + offsetY + (countSlice + offsetZ) * height)] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x + offsetX + wZP * (y + offsetY + (countSlice + offsetZ) * hZP)] = pixelTmp[count++];
                    }
                }
            }
        }
        return pixels;
    }

    public static double[] StackToDoubleArray1D(ImageStack stack) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            System.out.println("RGB images supported at the moment.");
            return null;
        }
        double[] pixels = new double[width * height * nstacks];
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x + width * (y + countSlice * height)] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x + width * (y + countSlice * height)] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x + width * (y + countSlice * height)] = pixelTmp[count++];
                    }
                }
            }
        }
        return pixels;
    }

    public static FloatArray3D StackToFloatArray(ImageStack stack) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            System.out.println("RGB images supported at the moment.");
            return null;
        }
        FloatArray3D pixels = new FloatArray3D(width, height, nstacks);
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++];
                    }
                }
            }
        }
        return pixels;
    }

    public static float[][][] StackToFloatArrayDeprecated(ImageStack stack) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            System.out.println("RGB images supported at the moment.");
            return null;
        }
        float[][][] pixels = new float[width][height][nstacks];
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x][y][countSlice] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x][y][countSlice] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels[x][y][countSlice] = pixelTmp[count++];
                    }
                }
            }
        }
        return pixels;
    }

    public static FloatArray4D StackToFloatArrayComplex(ImageStack stack) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        if (imageStack == null || imageStack.length == 0) {
            System.out.println("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            System.out.println("RGB images supported at the moment.");
            return null;
        }
        FloatArray4D pixels = new FloatArray4D(width, height, nstacks, 2);
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice, (int)0)] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice, (int)0)] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice, (int)0)] = pixelTmp[count++];
                    }
                }
            }
        }
        return pixels;
    }

    public static int[][] ImageToIntArray(ImageProcessor ip) {
        int[][] image;
        Object pixelArray = ip.getPixels();
        int count = 0;
        if (ip instanceof ByteProcessor) {
            image = new int[ip.getWidth()][ip.getHeight()];
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[x][y] = pixels[count++] & 0xFF;
                }
            }
        } else if (ip instanceof ShortProcessor) {
            image = new int[ip.getWidth()][ip.getHeight()];
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[x][y] = pixels[count++] & 0xFFFF;
                }
            }
        } else if (ip instanceof FloatProcessor) {
            image = new int[ip.getWidth()][ip.getHeight()];
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[x][y] = (int)pixels[count++];
                }
            }
        } else {
            image = new int[ip.getWidth()][ip.getHeight()];
            int[] nArray = (int[])pixelArray;
        }
        return image;
    }

    public static float[][] ImageToFloatArray2DDeprecated(ImageProcessor ip) {
        float[][] image;
        Object pixelArray = ip.getPixels();
        int count = 0;
        if (ip instanceof ByteProcessor) {
            image = new float[ip.getWidth()][ip.getHeight()];
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[x][y] = pixels[count++] & 0xFF;
                }
            }
        } else if (ip instanceof ShortProcessor) {
            image = new float[ip.getWidth()][ip.getHeight()];
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[x][y] = pixels[count++] & 0xFFFF;
                }
            }
        } else if (ip instanceof FloatProcessor) {
            image = new float[ip.getWidth()][ip.getHeight()];
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[x][y] = pixels[count++];
                }
            }
        } else {
            image = new float[ip.getWidth()][ip.getHeight()];
            int[] nArray = (int[])pixelArray;
        }
        return image;
    }

    public static double[] ImageToDoubleArray1D(ImageProcessor ip) {
        double[] image;
        Object pixelArray = ip.getPixels();
        int count = 0;
        if (ip instanceof ByteProcessor) {
            image = new double[ip.getWidth() * ip.getHeight()];
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[count] = pixels[count++] & 0xFF;
                }
            }
        } else if (ip instanceof ShortProcessor) {
            image = new double[ip.getWidth() * ip.getHeight()];
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[count] = pixels[count++] & 0xFFFF;
                }
            }
        } else if (ip instanceof FloatProcessor) {
            image = new double[ip.getWidth() * ip.getHeight()];
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[count] = pixels[count++];
                }
            }
        } else {
            image = new double[ip.getWidth() * ip.getHeight()];
            int[] nArray = (int[])pixelArray;
        }
        return image;
    }

    public static FloatArray2D ImageToFloatArray2D(ImageProcessor ip) {
        FloatArray2D image;
        Object pixelArray = ip.getPixels();
        int count = 0;
        if (ip instanceof ByteProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++] & 0xFF;
                }
            }
        } else if (ip instanceof ShortProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++] & 0xFFFF;
                }
            }
        } else if (ip instanceof FloatProcessor) {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.data[count] = pixels[count++];
                }
            }
        } else {
            image = new FloatArray2D(ip.getWidth(), ip.getHeight());
            int[] nArray = (int[])pixelArray;
        }
        return image;
    }

    public static void normFloatArray(FloatArray img) {
        float min = img.data[0];
        float max = img.data[0];
        for (float f : img.data) {
            if (f > max) {
                max = f;
            }
            if (!(f < min)) continue;
            min = f;
        }
        for (int i = 0; i < img.data.length; ++i) {
            img.data[i] = (img.data[i] - min) / (max - min);
        }
    }

    public static FloatArray2D drawTranslatedImages(FloatArray2D img1, FloatArray2D img2, Point shift, int drawType) {
        int w1 = img1.width;
        int h1 = img1.height;
        int w2 = img2.width;
        int h2 = img2.height;
        boolean createOverlappingImages = drawType == DRAWTYPE_OVERLAP;
        boolean createErrorMap = drawType == DRAWTYPE_ERRORMAP;
        int sx = shift.x;
        int sy = shift.y;
        int imgW = General.max(w1, w2) + General.max(0, Math.abs(sx) - Math.abs(w1 - w2));
        int imgH = General.max(h1, h2) + General.max(0, Math.abs(sy) - Math.abs(h1 - h2));
        FloatArray2D outputImg = new FloatArray2D(imgW, imgH);
        int offsetImg1X = General.max(0, -sx);
        int offsetImg1Y = General.max(0, -sy);
        int offsetImg2X = General.max(0, sx);
        int offsetImg2Y = General.max(0, sy);
        for (int y = 0; y < imgH; ++y) {
            for (int x = 0; x < imgW; ++x) {
                float pixel1 = img1.getZero(x - offsetImg1X, y - offsetImg1Y);
                float pixel2 = img2.getZero(x - offsetImg2X, y - offsetImg2Y);
                if (createOverlappingImages) {
                    outputImg.set((pixel1 + pixel2) / 2.0f, x, y);
                }
                if (x < offsetImg1X || x < offsetImg2X || x >= offsetImg1X + w1 || x >= offsetImg2X + w2 || y < offsetImg1Y || y < offsetImg2Y || y >= offsetImg1Y + h1 || y >= offsetImg2Y + h2 || !createErrorMap) continue;
                outputImg.set((pixel1 + pixel2) / 2.0f, x, y);
            }
        }
        return outputImg;
    }

    public static FloatArray2D zeroPad(FloatArray2D ip, int width, int height) {
        FloatArray2D image = new FloatArray2D(width, height);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        if (offsetX < 0) {
            System.err.println("mpi.fruitfly.general.ImageArrayConverter.ZeroPad(): Zero-Padding size in X smaller than image! " + width + " < " + ip.width);
            return null;
        }
        if (offsetY < 0) {
            System.err.println("mpi.fruitfly.general.ImageArrayConverter.ZeroPad(): Zero-Padding size in Y smaller than image! " + height + " < " + ip.height);
            return null;
        }
        int count = 0;
        for (int y = 0; y < ip.height; ++y) {
            for (int x = 0; x < ip.width; ++x) {
                image.set(ip.data[count++], x + offsetX, y + offsetY);
            }
        }
        return image;
    }

    public static FloatArray2D ImageToFloatArray2DZeroPadding(ImageProcessor ip, int width, int height) {
        FloatArray2D image = new FloatArray2D(width, height);
        Object pixelArray = ip.getPixels();
        int count = 0;
        int offsetX = (width - ip.getWidth()) / 2;
        int offsetY = (height - ip.getHeight()) / 2;
        if (offsetX < 0) {
            System.err.println("mpi.fruitfly.general.ImageArrayConverter.ImageToFloatArray2DZeroPadding(): Zero-Padding size in X smaller than image! " + width + " < " + ip.getWidth());
            return null;
        }
        if (offsetY < 0) {
            System.err.println("mpi.fruitfly.general.ImageArrayConverter.ImageToFloatArray2DZeroPadding(): Zero-Padding size in Y smaller than image! " + height + " < " + ip.getHeight());
            return null;
        }
        if (ip instanceof ByteProcessor) {
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.set(pixels[count++] & 0xFF, x + offsetX, y + offsetY);
                }
            }
        } else if (ip instanceof ShortProcessor) {
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.set(pixels[count++] & 0xFFFF, x + offsetX, y + offsetY);
                }
            }
        } else if (ip instanceof FloatProcessor) {
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image.set(pixels[count++], x + offsetX, y + offsetY);
                }
            }
        } else {
            int[] nArray = (int[])pixelArray;
        }
        return image;
    }

    public static double[] ImageToDoubleArray1DZeroPadding(ImageProcessor ip, int width, int height) {
        double[] image;
        Object pixelArray = ip.getPixels();
        int count = 0;
        int offsetX = (width - ip.getWidth()) / 2;
        int offsetY = (height - ip.getHeight()) / 2;
        if (offsetX < 0) {
            System.err.println("mpi.fruitfly.general.ImageArrayConverter.ImageToDoubleArray1DZeroPadding(): Zero-Padding size in X smaller than image! " + width + " < " + ip.getWidth());
            return null;
        }
        if (offsetY < 0) {
            System.err.println("mpi.fruitfly.general.ImageArrayConverter.ImageToDoubleArray1DZeroPadding(): Zero-Padding size in Y smaller than image! " + height + " < " + ip.getHeight());
            return null;
        }
        if (ip instanceof ByteProcessor) {
            image = new double[width * height];
            byte[] pixels = (byte[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[(y + offsetY) * width + x + offsetX] = pixels[count++] & 0xFF;
                }
            }
        } else if (ip instanceof ShortProcessor) {
            image = new double[width * height];
            short[] pixels = (short[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[(y + offsetY) * width + x + offsetX] = pixels[count++] & 0xFFFF;
                }
            }
        } else if (ip instanceof FloatProcessor) {
            image = new double[width * height];
            float[] pixels = (float[])pixelArray;
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    image[(y + offsetY) * width + x + offsetX] = pixels[count++];
                }
            }
        } else {
            image = new double[width * height];
            int[] nArray = (int[])pixelArray;
        }
        return image;
    }

    public static void ArrayToByteProcessor(ImageProcessor ip, int[][] pixels) {
        byte[] data = new byte[pixels.length * pixels[0].length];
        int count = 0;
        for (int y = 0; y < pixels[0].length; ++y) {
            for (int x = 0; x < pixels.length; ++x) {
                data[count++] = (byte)(pixels[x][y] & 0xFF);
            }
        }
        ip.setPixels((Object)data);
    }

    public static void ArrayToByteProcessor(ImageProcessor ip, float[][] pixels) {
        byte[] data = new byte[pixels.length * pixels[0].length];
        int count = 0;
        for (int y = 0; y < pixels[0].length; ++y) {
            for (int x = 0; x < pixels.length; ++x) {
                data[count++] = (byte)((int)pixels[x][y] & 0xFF);
            }
        }
        ip.setPixels((Object)data);
    }

    public static void ArrayToFloatProcessor(ImageProcessor ip, double[] pixels, int width, int height) {
        float[] data = new float[width * height];
        int count = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[count] = (float)pixels[count++];
            }
        }
        ip.setPixels((Object)data);
        ip.resetMinAndMax();
    }

    public static void ArrayToFloatProcessor(ImageProcessor ip, float[] pixels, int width, int height) {
        float[] data = new float[width * height];
        int count = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                data[count] = pixels[count++];
            }
        }
        ip.setPixels((Object)data);
        ip.resetMinAndMax();
    }

    public static void FloatArrayToFloatProcessor(ImageProcessor ip, FloatArray2D pixels) {
        float[] data = new float[pixels.width * pixels.height];
        int count = 0;
        for (int y = 0; y < pixels.height; ++y) {
            for (int x = 0; x < pixels.width; ++x) {
                data[count] = pixels.data[count++];
            }
        }
        ip.setPixels((Object)data);
        ip.resetMinAndMax();
    }

    public static void normPixelValuesToByte(int[][] pixels, boolean cutoff) {
        int max = 0;
        int min = 255;
        for (int y = 0; y < pixels[0].length; ++y) {
            for (int x = 0; x < pixels.length; ++x) {
                if (cutoff) {
                    if (pixels[x][y] < 0) {
                        pixels[x][y] = 0;
                    }
                    if (pixels[x][y] <= 255) continue;
                    pixels[x][y] = 255;
                    continue;
                }
                if (pixels[x][y] < min) {
                    min = pixels[x][y];
                }
                if (pixels[x][y] <= max) continue;
                max = pixels[x][y];
            }
        }
        if (cutoff) {
            return;
        }
        if (max > 255 || min < 0) {
            double factor = (double)(max - min) / 255.0;
            for (int y = 0; y < pixels[0].length; ++y) {
                for (int x = 0; x < pixels.length; ++x) {
                    pixels[x][y] = (int)((double)(pixels[x][y] - min) / factor);
                }
            }
        }
    }

    public static void normPixelValuesToByte(float[][] pixels, boolean cutoff) {
        float max = 0.0f;
        float min = 255.0f;
        for (int y = 0; y < pixels[0].length; ++y) {
            for (int x = 0; x < pixels.length; ++x) {
                if (cutoff) {
                    if (pixels[x][y] < 0.0f) {
                        pixels[x][y] = 0.0f;
                    }
                    if (!(pixels[x][y] > 255.0f)) continue;
                    pixels[x][y] = 255.0f;
                    continue;
                }
                if (pixels[x][y] < min) {
                    min = pixels[x][y];
                }
                if (!(pixels[x][y] > max)) continue;
                max = pixels[x][y];
            }
        }
        if (cutoff) {
            return;
        }
        if (max > 255.0f || min < 0.0f) {
            double factor = (double)(max - min) / 255.0;
            for (int y = 0; y < pixels[0].length; ++y) {
                for (int x = 0; x < pixels.length; ++x) {
                    pixels[x][y] = (int)((double)(pixels[x][y] - min) / factor);
                }
            }
        }
    }

    public static void normPixelValuesToByte(float[][][] pixels, boolean cutoff) {
        float max = 0.0f;
        float min = 255.0f;
        for (int z = 0; z < pixels[0][0].length; ++z) {
            for (int y = 0; y < pixels[0].length; ++y) {
                for (int x = 0; x < pixels.length; ++x) {
                    if (cutoff) {
                        if (pixels[x][y][z] < 0.0f) {
                            pixels[x][y][z] = 0.0f;
                        }
                        if (!(pixels[x][y][z] > 255.0f)) continue;
                        pixels[x][y][z] = 255.0f;
                        continue;
                    }
                    if (pixels[x][y][z] < min) {
                        min = pixels[x][y][z];
                    }
                    if (!(pixels[x][y][z] > max)) continue;
                    max = pixels[x][y][z];
                }
            }
        }
        if (cutoff) {
            return;
        }
        if (max > 255.0f || min < 0.0f) {
            double factor = (double)(max - min) / 255.0;
            for (int z = 0; z < pixels[0][0].length; ++z) {
                for (int y = 0; y < pixels[0].length; ++y) {
                    for (int x = 0; x < pixels.length; ++x) {
                        pixels[x][y][z] = (int)((double)(pixels[x][y][z] - min) / factor);
                    }
                }
            }
        }
    }
}

