/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import bunwarpj.Param;
import bunwarpj.Transformation;
import bunwarpj.bUnwarpJ_;
import bunwarpj.trakem2.transform.CubicBSplineTransform;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import ini.trakem2.display.Display;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.Filter;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Choice;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import mpicbg.ij.FeatureTransform;
import mpicbg.ij.SIFT;
import mpicbg.ij.util.Util;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Transforms;
import mpicbg.trakem2.align.Align;
import mpicbg.trakem2.align.AlignTask;
import mpicbg.trakem2.align.ElasticLayerAlignment;
import mpicbg.trakem2.align.RegularizedAffineLayerAlignment;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.RigidModel2D;
import mpicbg.trakem2.transform.TranslationModel2D;

public final class AlignLayersTask {
    protected static int LINEAR = 0;
    protected static int BUNWARPJ = 1;
    protected static int ELASTIC = 2;
    protected static int mode = LINEAR;
    static final String[] modeStrings = new String[]{"least squares (linear feature correspondences)", "bUnwarpJ (non-linear cubic B-Splines)", "elastic (non-linear block correspondences)"};
    protected static boolean propagateTransformBefore = false;
    protected static boolean propagateTransformAfter = false;
    protected static Param elasticParam = new Param();

    private AlignLayersTask() {
    }

    public static final Bureaucrat alignLayersTask(Layer l) {
        return AlignLayersTask.alignLayersTask(l, null);
    }

    public static final Bureaucrat alignLayersTask(final Layer l, final Rectangle fov) {
        Worker worker = new Worker("Aligning layers", false, true){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    AlignLayersTask.alignLayers(l, fov);
                }
                catch (Throwable e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, l.getProject());
    }

    public static final void alignLayers(Layer l) throws Exception {
        AlignLayersTask.alignLayers(l, null);
    }

    public static final void alignLayers(Layer l, Rectangle fov) throws Exception {
        ArrayList<Layer> layers = l.getParent().getLayers();
        String[] layerTitles = new String[layers.size()];
        String[] noneAndLayerTitles = new String[layers.size() + 1];
        noneAndLayerTitles[0] = "*None*";
        for (int i = 0; i < layers.size(); ++i) {
            layerTitles[i] = l.getProject().findLayerThing(layers.get(i)).toString();
            noneAndLayerTitles[i + 1] = layerTitles[i];
        }
        GenericDialog gd = new GenericDialog("Align Layers");
        gd.addChoice("mode :", modeStrings, modeStrings[LINEAR]);
        gd.addMessage("Layer Range:");
        int sel = l.getParent().indexOf(l);
        gd.addChoice("first :", layerTitles, layerTitles[sel]);
        gd.addChoice("reference :", noneAndLayerTitles, layerTitles[sel]);
        gd.addChoice("last :", layerTitles, layerTitles[sel]);
        gd.addStringField("Use only images whose title matches:", "", 30);
        gd.addCheckbox("Use visible images only", true);
        gd.addCheckbox("propagate transform to first layer", propagateTransformBefore);
        gd.addCheckbox("propagate transform to last layer", propagateTransformAfter);
        Vector v = gd.getChoices();
        final Choice cstart = (Choice)v.get(v.size() - 3);
        final Choice cref = (Choice)v.get(v.size() - 2);
        final Choice cend = (Choice)v.get(v.size() - 1);
        ItemListener startEndListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int startIndex = cstart.getSelectedIndex();
                int endIndex = cend.getSelectedIndex();
                int refIndex = cref.getSelectedIndex();
                int min = Math.min(startIndex, endIndex);
                int max = Math.max(startIndex, endIndex);
                if (cref.getSelectedIndex() > 0) {
                    cref.select(Math.min(max + 1, Math.max(min + 1, refIndex)));
                }
            }
        };
        cstart.addItemListener(startEndListener);
        cend.addItemListener(startEndListener);
        cref.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int startIndex = cstart.getSelectedIndex();
                int endIndex = cend.getSelectedIndex();
                int refIndex = cref.getSelectedIndex() - 1;
                int min = Math.min(startIndex, endIndex);
                int max = Math.max(startIndex, endIndex);
                if (refIndex >= 0) {
                    if (refIndex < min) {
                        if (startIndex <= endIndex) {
                            cstart.select(refIndex);
                        } else {
                            cend.select(refIndex);
                        }
                    } else if (refIndex > max) {
                        if (startIndex <= endIndex) {
                            cend.select(refIndex);
                        } else {
                            cstart.select(refIndex);
                        }
                    }
                }
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        mode = gd.getNextChoiceIndex();
        int first = gd.getNextChoiceIndex();
        int ref = gd.getNextChoiceIndex() - 1;
        int last = gd.getNextChoiceIndex();
        String toMatch1 = gd.getNextString().trim();
        final String toMatch2 = 0 == toMatch1.length() ? null : ".*" + toMatch1 + ".*";
        final boolean visibleOnly = gd.getNextBoolean();
        propagateTransformBefore = gd.getNextBoolean();
        propagateTransformAfter = gd.getNextBoolean();
        Filter<Patch> filter = new Filter<Patch>(){

            @Override
            public final boolean accept(Patch patch) {
                if (visibleOnly && !patch.isVisible()) {
                    return false;
                }
                return null == toMatch2 || patch.getTitle().matches(toMatch2);
            }
        };
        if (mode == ELASTIC) {
            new ElasticLayerAlignment().exec(l.getParent(), first, last, ref, propagateTransformBefore, propagateTransformAfter, fov, filter);
        } else if (mode == LINEAR) {
            new RegularizedAffineLayerAlignment().exec(l.getParent(), first, last, ref, propagateTransformBefore, propagateTransformAfter, fov, filter);
        } else {
            GenericDialog gd2 = new GenericDialog("Align Layers");
            Align.param.addFields(gd2);
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return;
            }
            Align.param.readFields(gd2);
            if (mode == BUNWARPJ && !elasticParam.showDialog()) {
                return;
            }
            if (ref - first > 0) {
                if (mode == BUNWARPJ) {
                    AlignLayersTask.alignLayersNonLinearlyJob(l.getParent(), ref, first, propagateTransformBefore, fov, filter);
                } else {
                    AlignLayersTask.alignLayersLinearlyJob(l.getParent(), ref, first, propagateTransformBefore, fov, filter);
                }
            }
            if (last - ref > 0) {
                if (mode == BUNWARPJ) {
                    AlignLayersTask.alignLayersNonLinearlyJob(l.getParent(), ref, last, propagateTransformAfter, fov, filter);
                } else {
                    AlignLayersTask.alignLayersLinearlyJob(l.getParent(), ref, last, propagateTransformAfter, fov, filter);
                }
            }
        }
    }

    public static final void alignLayersLinearlyJob(LayerSet layerSet, int first, int last, boolean propagateTransform, Rectangle fov, Filter<Patch> filter) {
        block34: {
            AffineTransform a;
            block35: {
                List<Layer> layerRange = layerSet.getLayers(first, last);
                Align.Param p = Align.param.clone();
                Rectangle box = fov;
                Iterator<Layer> it = layerRange.iterator();
                while (it.hasNext()) {
                    Layer la = it.next();
                    if (!la.contains(Patch.class, true)) {
                        it.remove();
                        continue;
                    }
                    if (null != box) continue;
                    box = la.getMinimalBoundingBox(Patch.class, true);
                }
                if (0 == layerRange.size()) {
                    Utils.log("All layers in range are empty!");
                    return;
                }
                if (layerRange.size() < 2) {
                    return;
                }
                double scale = Math.min(1.0, Math.min((double)p.sift.maxOctaveSize / (double)box.width, (double)p.sift.maxOctaveSize / (double)box.height));
                p.maxEpsilon = (float)((double)p.maxEpsilon * scale);
                p.identityTolerance = (float)((double)p.identityTolerance * scale);
                FloatArray2DSIFT sift = new FloatArray2DSIFT(p.sift);
                SIFT ijSIFT = new SIFT(sift);
                Rectangle box1 = fov;
                Rectangle box2 = fov;
                ArrayList features1 = new ArrayList();
                ArrayList features2 = new ArrayList();
                ArrayList candidates = new ArrayList();
                ArrayList inliers = new ArrayList();
                a = new AffineTransform();
                int s = 0;
                for (Layer layer : layerRange) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    long t0 = System.currentTimeMillis();
                    features1.clear();
                    features1.addAll(features2);
                    features2.clear();
                    Rectangle box3 = layer.getMinimalBoundingBox(Patch.class, true);
                    if (box3 == null || box3.width == 0 && box3.height == 0) continue;
                    box1 = null == fov ? box2 : fov;
                    box2 = null == fov ? box3 : fov;
                    ArrayList<Patch> patches = layer.getAll(Patch.class);
                    if (null != filter) {
                        Iterator it2 = patches.iterator();
                        while (it2.hasNext()) {
                            if (filter.accept((Patch)it2.next())) continue;
                            it2.remove();
                        }
                    }
                    ImageProcessor flatImage = layer.getProject().getLoader().getFlatImage(layer, box2, scale, -1, 0, Patch.class, patches, true).getProcessor();
                    ijSIFT.extractFeatures(flatImage, features2);
                    IJ.log((String)(features2.size() + " features extracted in layer \"" + layer.getTitle() + "\" (took " + (System.currentTimeMillis() - t0) + " ms)."));
                    if (features1.size() > 0) {
                        boolean modelFound;
                        TranslationModel2D desiredModel;
                        TranslationModel2D model;
                        long t1 = System.currentTimeMillis();
                        candidates.clear();
                        FeatureTransform.matchFeatures(features2, features1, candidates, (float)p.rod);
                        switch (p.expectedModelIndex) {
                            case 0: {
                                model = new TranslationModel2D();
                                break;
                            }
                            case 1: {
                                model = new RigidModel2D();
                                break;
                            }
                            case 2: {
                                model = new SimilarityModel2D();
                                break;
                            }
                            case 3: {
                                model = new AffineModel2D();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        switch (p.desiredModelIndex) {
                            case 0: {
                                desiredModel = new TranslationModel2D();
                                break;
                            }
                            case 1: {
                                desiredModel = new RigidModel2D();
                                break;
                            }
                            case 2: {
                                desiredModel = new SimilarityModel2D();
                                break;
                            }
                            case 3: {
                                desiredModel = new AffineModel2D();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        boolean again = false;
                        try {
                            do {
                                again = false;
                                modelFound = model.filterRansac(candidates, inliers, 1000, (double)p.maxEpsilon, (double)p.minInlierRatio, p.minNumInliers, 3.0);
                                if (!modelFound || !p.rejectIdentity) continue;
                                ArrayList points = new ArrayList();
                                PointMatch.sourcePoints(inliers, points);
                                if (!Transforms.isIdentity((CoordinateTransform)model, points, (double)p.identityTolerance)) continue;
                                IJ.log((String)("Identity transform for " + inliers.size() + " matches rejected."));
                                candidates.removeAll(inliers);
                                inliers.clear();
                                again = true;
                            } while (again);
                            if (modelFound) {
                                desiredModel.fit(inliers);
                            }
                        }
                        catch (NotEnoughDataPointsException e) {
                            modelFound = false;
                        }
                        catch (IllDefinedDataPointsException e) {
                            modelFound = false;
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        if (modelFound) {
                            IJ.log((String)("Model found for layer \"" + layer.getTitle() + "\" and its predecessor:\n  correspondences  " + inliers.size() + " of " + candidates.size() + "\n  average residual error  " + model.getCost() / scale + " px\n  took " + (System.currentTimeMillis() - t1) + " ms"));
                            AffineTransform b = new AffineTransform();
                            b.translate(box1.x, box1.y);
                            b.scale(1.0 / scale, 1.0 / scale);
                            b.concatenate(desiredModel.createAffine());
                            b.scale(scale, scale);
                            b.translate(-box2.x, -box2.y);
                            a.concatenate(b);
                            AlignTask.transformPatchesAndVectorData(patches, a);
                            Display.repaint(layer);
                        } else {
                            IJ.log((String)("No model found for layer \"" + layer.getTitle() + "\" and its predecessor:\n  correspondence candidates  " + candidates.size() + "\n  took " + (System.currentTimeMillis() - (long)s) + " ms"));
                            a.setToIdentity();
                        }
                    }
                    IJ.showProgress((int)(++s), (int)layerRange.size());
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (!propagateTransform) break block34;
                if (last <= first || last >= layerSet.size() - 2) break block35;
                for (Layer la : layerSet.getLayers(last + 1, layerSet.size() - 1)) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    AlignTask.transformPatchesAndVectorData(la, a);
                }
                break block34;
            }
            if (first <= last || last <= 0) break block34;
            for (Layer la : layerSet.getLayers(0, last - 1)) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                AlignTask.transformPatchesAndVectorData(la, a);
            }
        }
    }

    public static final void alignLayersNonLinearlyJob(final LayerSet layerSet, int first, int last, final boolean propagateTransform, final Rectangle fov, final Filter<Patch> filter) {
        final List<Layer> layerRange = layerSet.getLayers(first, last);
        final Align.Param p = Align.param.clone();
        Iterator<Layer> it = layerRange.iterator();
        while (it.hasNext()) {
            if (it.next().contains(Patch.class, true)) continue;
            it.remove();
        }
        if (0 == layerRange.size()) {
            Utils.log("No layers in range show any images!");
            return;
        }
        if (layerRange.size() < 2) {
            return;
        }
        ArrayList<Patch> all = new ArrayList<Patch>();
        for (Layer la : layerRange) {
            for (Patch patch : la.getAll(Patch.class)) {
                if (null != filter && !filter.accept(patch)) continue;
                all.add(patch);
            }
        }
        AlignTask.transformPatchesAndVectorData(all, new Runnable(){

            @Override
            public void run() {
                final Loader loader = layerSet.getProject().getLoader();
                final SIFT ijSIFT1 = new SIFT(new FloatArray2DSIFT(p.sift));
                final SIFT ijSIFT2 = new SIFT(new FloatArray2DSIFT(p.sift));
                final ArrayList features1 = new ArrayList();
                final ArrayList features2 = new ArrayList();
                ArrayList candidates = new ArrayList();
                ArrayList inliers = new ArrayList();
                int n_proc = Runtime.getRuntime().availableProcessors() > 1 ? 2 : 1;
                ThreadPoolExecutor exec = Utils.newFixedThreadPool(n_proc, "alignLayersNonLinearly");
                ArrayList<Patch> previousPatches = null;
                int s = 0;
                for (int i = 1; i < layerRange.size() && !Thread.currentThread().isInterrupted(); ++i) {
                    ImageProcessor ip2;
                    ImageProcessor ip1;
                    ArrayList<Patch> patches1;
                    final Layer layer1 = (Layer)layerRange.get(i - 1);
                    final Layer layer2 = (Layer)layerRange.get(i);
                    final long t0 = System.currentTimeMillis();
                    features1.clear();
                    features2.clear();
                    final Rectangle box1 = null == fov ? layer1.getMinimalBoundingBox(Patch.class, true) : fov;
                    final Rectangle box2 = null == fov ? layer2.getMinimalBoundingBox(Patch.class, true) : fov;
                    final double scale = Math.min(1.0, (double)p.sift.maxOctaveSize / (double)Math.max(box1.width, Math.max(box1.height, Math.max(box2.width, box2.height))));
                    if (null == previousPatches) {
                        patches1 = layer1.getAll(Patch.class);
                        if (null != filter) {
                            Iterator it = patches1.iterator();
                            while (it.hasNext()) {
                                if (filter.accept(it.next())) continue;
                                it.remove();
                            }
                        }
                    } else {
                        patches1 = previousPatches;
                    }
                    final ArrayList<Patch> patches2 = layer2.getAll(Patch.class);
                    if (null != filter) {
                        Iterator it = patches2.iterator();
                        while (it.hasNext()) {
                            if (filter.accept(it.next())) continue;
                            it.remove();
                        }
                    }
                    Future<ImageProcessor> fu1 = exec.submit(new Callable<ImageProcessor>(){

                        @Override
                        public ImageProcessor call() {
                            ImageProcessor ip1 = loader.getFlatImage(layer1, box1, scale, -1, 0, Patch.class, patches1, true).getProcessor();
                            ijSIFT1.extractFeatures(ip1, features1);
                            Utils.log(features1.size() + " features extracted in layer \"" + layer1.getTitle() + "\" (took " + (System.currentTimeMillis() - t0) + " ms).");
                            return ip1;
                        }
                    });
                    Future<ImageProcessor> fu2 = exec.submit(new Callable<ImageProcessor>(){

                        @Override
                        public ImageProcessor call() {
                            ImageProcessor ip2 = loader.getFlatImage(layer2, box2, scale, -1, 0, Patch.class, patches2, true).getProcessor();
                            ijSIFT2.extractFeatures(ip2, features2);
                            Utils.log(features2.size() + " features extracted in layer \"" + layer2.getTitle() + "\" (took " + (System.currentTimeMillis() - t0) + " ms).");
                            return ip2;
                        }
                    });
                    try {
                        ip1 = fu1.get();
                        ip2 = fu2.get();
                    }
                    catch (Exception e) {
                        IJError.print(e);
                        return;
                    }
                    if (features1.size() > 0 && features2.size() > 0) {
                        boolean modelFound;
                        TranslationModel2D model;
                        long t1 = System.currentTimeMillis();
                        candidates.clear();
                        FeatureTransform.matchFeatures(features2, features1, candidates, (float)p.rod);
                        switch (p.expectedModelIndex) {
                            case 0: {
                                model = new TranslationModel2D();
                                break;
                            }
                            case 1: {
                                model = new RigidModel2D();
                                break;
                            }
                            case 2: {
                                model = new SimilarityModel2D();
                                break;
                            }
                            case 3: {
                                model = new AffineModel2D();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        boolean again = false;
                        try {
                            do {
                                again = false;
                                modelFound = model.filterRansac(candidates, inliers, 1000, (double)p.maxEpsilon, (double)p.minInlierRatio, p.minNumInliers, 3.0);
                                if (!modelFound || !p.rejectIdentity) continue;
                                ArrayList points = new ArrayList();
                                PointMatch.sourcePoints(inliers, points);
                                if (!Transforms.isIdentity((CoordinateTransform)model, points, (double)p.identityTolerance)) continue;
                                IJ.log((String)("Identity transform for " + inliers.size() + " matches rejected."));
                                candidates.removeAll(inliers);
                                inliers.clear();
                                again = true;
                            } while (again);
                        }
                        catch (NotEnoughDataPointsException e) {
                            modelFound = false;
                        }
                        if (modelFound) {
                            IJ.log((String)("Model found for layer \"" + layer2.getTitle() + "\" and its predecessor:\n  correspondences  " + inliers.size() + " of " + candidates.size() + "\n  average residual error  " + model.getCost() / scale + " px\n  took " + (System.currentTimeMillis() - t1) + " ms"));
                            ImagePlus imp1 = new ImagePlus("target", ip1);
                            ImagePlus imp2 = new ImagePlus("source", ip2);
                            ArrayList sourcePoints = new ArrayList();
                            ArrayList targetPoints = new ArrayList();
                            PointMatch.sourcePoints(inliers, sourcePoints);
                            PointMatch.targetPoints(inliers, targetPoints);
                            imp2.setRoi((Roi)Util.pointsToPointRoi(sourcePoints));
                            imp1.setRoi((Roi)Util.pointsToPointRoi(targetPoints));
                            ImageProcessor mask1 = ip1.duplicate();
                            mask1.threshold(1);
                            ImageProcessor mask2 = ip2.duplicate();
                            mask2.threshold(1);
                            Transformation warp = bUnwarpJ_.computeTransformationBatch((ImagePlus)imp2, (ImagePlus)imp1, (ImageProcessor)mask2, (ImageProcessor)mask1, (Param)elasticParam);
                            CubicBSplineTransform transf = new CubicBSplineTransform();
                            transf.set(warp.getIntervals(), warp.getDirectDeformationCoefficientsX(), warp.getDirectDeformationCoefficientsY(), imp2.getWidth(), imp2.getHeight());
                            ArrayList fus = new ArrayList();
                            for (Patch patch : patches2) {
                                try {
                                    Rectangle pbox = patch.getCoordinateTransformBoundingBox();
                                    AffineTransform at = patch.getAffineTransform();
                                    AffineTransform pat = new AffineTransform();
                                    pat.scale(scale, scale);
                                    pat.translate(-box2.x, -box2.y);
                                    pat.concatenate(at);
                                    pat.translate(-pbox.x, -pbox.y);
                                    mpicbg.trakem2.transform.AffineModel2D toWorld = new mpicbg.trakem2.transform.AffineModel2D();
                                    toWorld.set(pat);
                                    CoordinateTransformList ctl = new CoordinateTransformList();
                                    ctl.add((CoordinateTransform)toWorld);
                                    ctl.add((CoordinateTransform)transf);
                                    ctl.add((CoordinateTransform)toWorld.createInverse());
                                    patch.appendCoordinateTransform((mpicbg.trakem2.transform.CoordinateTransform)ctl);
                                    fus.add(patch.updateMipMaps());
                                    AffineTransform offset = new AffineTransform();
                                    offset.translate(box1.x - box2.x, box1.y - box2.y);
                                    offset.concatenate(at);
                                    patch.setAffineTransform(offset);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            Utils.wait(fus);
                            Display.repaint(layer2);
                        } else {
                            IJ.log((String)("No model found for layer \"" + layer2.getTitle() + "\" and its predecessor:\n  correspondence candidates  " + candidates.size() + "\n  took " + (System.currentTimeMillis() - (long)s) + " ms"));
                        }
                    }
                    IJ.showProgress((int)(++s), (int)layerRange.size());
                    previousPatches = patches2;
                }
                exec.shutdown();
                if (propagateTransform) {
                    Utils.log("Propagation not implemented yet for non-linear layer alignment.");
                }
            }
        });
    }
}

