/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.event;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TransformEdit
extends AbstractUndoableEdit {
    private Collection<Figure> figures;
    private AffineTransform tx;

    public TransformEdit(Figure figure, AffineTransform tx) {
        this.figures = new LinkedList<Figure>();
        ((LinkedList)this.figures).add(figure);
        this.tx = (AffineTransform)tx.clone();
    }

    public TransformEdit(Collection<Figure> figures, AffineTransform tx) {
        this.figures = figures;
        this.tx = (AffineTransform)tx.clone();
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        return labels.getString("edit.transform.text");
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof TransformEdit) {
            TransformEdit that = (TransformEdit)anEdit;
            if (that.figures == this.figures) {
                this.tx.concatenate(that.tx);
                that.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        if (anEdit instanceof TransformEdit) {
            TransformEdit that = (TransformEdit)anEdit;
            if (that.figures == this.figures) {
                this.tx.preConcatenate(that.tx);
                that.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (Figure f : this.figures) {
            f.willChange();
            f.transform(this.tx);
            f.changed();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            AffineTransform inverse = this.tx.createInverse();
            for (Figure f : this.figures) {
                f.willChange();
                f.transform(inverse);
                f.changed();
            }
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + this.hashCode() + " tx:" + this.tx;
    }
}

