/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jhotdraw.geom.Polygon2D;

public class ConvexHull {
    public static Polygon getConvexHullPolygon(List<Point> points) {
        Polygon convexHull = new Polygon();
        for (Point p : ConvexHull.getConvexHull(points.toArray(new Point[points.size()]))) {
            convexHull.addPoint(p.x, p.y);
        }
        return convexHull;
    }

    public static Polygon2D.Double getConvexHullPath2D(List<Point2D.Double> points) {
        Polygon2D.Double convexHull = new Polygon2D.Double();
        for (Point p : ConvexHull.getConvexHull(points.toArray(new Point[points.size()]))) {
            convexHull.add(p);
        }
        return convexHull;
    }

    public static Polygon2D.Double getConvexHullPath2D(Shape shape) {
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        double[] coords = new double[6];
        PathIterator i = shape.getPathIterator(null);
        while (!i.isDone()) {
            switch (i.currentSegment(coords)) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    points.add(new Point2D.Double(coords[0], coords[1]));
                    break;
                }
                case 2: {
                    points.add(new Point2D.Double(coords[0], coords[1]));
                    points.add(new Point2D.Double(coords[2], coords[3]));
                    break;
                }
                case 3: {
                    points.add(new Point2D.Double(coords[0], coords[1]));
                    points.add(new Point2D.Double(coords[2], coords[3]));
                    points.add(new Point2D.Double(coords[4], coords[5]));
                }
            }
            i.next();
        }
        Polygon2D.Double convexHull = new Polygon2D.Double();
        for (Point2D.Double p : ConvexHull.getConvexHull2D(points.toArray(new Point2D.Double[points.size()]))) {
            convexHull.add(p);
        }
        return convexHull;
    }

    public static List<Point> getConvexHull(List<Point> points) {
        return Arrays.asList(ConvexHull.getConvexHull(points.toArray(new Point[points.size()])));
    }

    public static List<Point2D.Double> getConvexHull2D(List<Point2D.Double> points) {
        return Arrays.asList(ConvexHull.getConvexHull2D(points.toArray(new Point2D.Double[points.size()])));
    }

    public static Point[] getConvexHull(Point[] points) {
        if (points.length < 3) {
            return (Point[])points.clone();
        }
        Point[] sorted = (Point[])points.clone();
        Arrays.sort(sorted, new Comparator<Point>(){

            @Override
            public int compare(Point o1, Point o2) {
                int v = o1.x - o2.x;
                return v == 0 ? o1.y - o2.y : v;
            }
        });
        Point[] hull = new Point[sorted.length + 2];
        int upper = 0;
        hull[upper++] = sorted[0];
        hull[upper++] = sorted[1];
        for (int i = 2; i < sorted.length; ++i) {
            hull[upper++] = sorted[i];
            while (upper > 2 && !ConvexHull.isRightTurn(hull[upper - 3], hull[upper - 2], hull[upper - 1])) {
                hull[upper - 2] = hull[upper - 1];
                --upper;
            }
        }
        int lower = upper;
        hull[lower++] = sorted[sorted.length - 2];
        for (int i = sorted.length - 3; i >= 0; --i) {
            hull[lower++] = sorted[i];
            while (lower - upper > 1 && !ConvexHull.isRightTurn(hull[lower - 3], hull[lower - 2], hull[lower - 1])) {
                hull[lower - 2] = hull[lower - 1];
                --lower;
            }
        }
        Point[] convexHull = new Point[--lower];
        System.arraycopy(hull, 0, convexHull, 0, lower);
        return convexHull;
    }

    public static boolean isRightTurn(Point p1, Point p2, Point p3) {
        if (p1.equals(p2) || p2.equals(p3)) {
            return false;
        }
        double val = p2.x * p3.y + p1.x * p2.y + p3.x * p1.y - (p2.x * p1.y + p3.x * p2.y + p1.x * p3.y);
        return val > 0.0;
    }

    public static Point2D.Double[] getConvexHull2D(Point2D.Double[] points) {
        if (points.length < 3) {
            return (Point2D.Double[])points.clone();
        }
        Point2D.Double[] sorted = (Point2D.Double[])points.clone();
        Arrays.sort(sorted, new Comparator<Point2D.Double>(){

            @Override
            public int compare(Point2D.Double o1, Point2D.Double o2) {
                double v = o1.x - o2.x;
                if (v == 0.0) {
                    v = o1.y - o2.y;
                }
                return v > 0.0 ? 1 : (v < 0.0 ? -1 : 0);
            }
        });
        Point2D.Double[] hull = new Point2D.Double[sorted.length + 2];
        int upper = 0;
        hull[upper++] = sorted[0];
        hull[upper++] = sorted[1];
        for (int i = 2; i < sorted.length; ++i) {
            hull[upper++] = sorted[i];
            while (upper > 2 && !ConvexHull.isRightTurn2D(hull[upper - 3], hull[upper - 2], hull[upper - 1])) {
                hull[upper - 2] = hull[upper - 1];
                --upper;
            }
        }
        int lower = upper;
        hull[lower++] = sorted[sorted.length - 2];
        for (int i = sorted.length - 3; i >= 0; --i) {
            hull[lower++] = sorted[i];
            while (lower - upper > 1 && !ConvexHull.isRightTurn2D(hull[lower - 3], hull[lower - 2], hull[lower - 1])) {
                hull[lower - 2] = hull[lower - 1];
                --lower;
            }
        }
        Point2D.Double[] convexHull = new Point2D.Double[--lower];
        System.arraycopy(hull, 0, convexHull, 0, lower);
        return convexHull;
    }

    public static boolean isRightTurn2D(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3) {
        if (p1.equals(p2) || p2.equals(p3)) {
            return false;
        }
        double val = p2.x * p3.y + p1.x * p2.y + p3.x * p1.y - (p2.x * p1.y + p3.x * p2.y + p1.x * p3.y);
        return val > 0.0;
    }
}

