/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.geom.Geom;

public class GrowStroke
extends DoubleStroke {
    private double grow;

    public GrowStroke(double grow, double miterLimit) {
        super(grow * 2.0, 1.0, 2, 2, miterLimit, null, 0.0f);
        this.grow = grow;
    }

    @Override
    public Shape createStrokedShape(Shape s) {
        BezierPath bp = new BezierPath();
        Path2D.Double left = new Path2D.Double();
        Path2D.Double right = new Path2D.Double();
        if (s instanceof Path2D.Double) {
            left.setWindingRule(((Path2D.Double)s).getWindingRule());
            right.setWindingRule(((Path2D.Double)s).getWindingRule());
        } else if (s instanceof BezierPath) {
            left.setWindingRule(((BezierPath)s).getWindingRule());
            right.setWindingRule(((BezierPath)s).getWindingRule());
        }
        double[] coords = new double[6];
        PathIterator i = s.getPathIterator(null, 0.1);
        while (!i.isDone()) {
            int type = i.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (bp.size() != 0) {
                        this.traceStroke(bp, left, right);
                    }
                    bp.clear();
                    bp.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    if (coords[0] == ((BezierPath.Node)bp.get((int)(bp.size() - 1))).x[0] && coords[1] == ((BezierPath.Node)bp.get((int)(bp.size() - 1))).y[0]) break;
                    bp.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    bp.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    bp.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    bp.setClosed(true);
                }
            }
            i.next();
        }
        if (bp.size() > 1) {
            this.traceStroke(bp, left, right);
        }
        if (Geom.contains(left.getBounds2D(), right.getBounds2D())) {
            return this.grow > 0.0 ? left : right;
        }
        return this.grow > 0.0 ? right : left;
    }
}

