/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.samples.svg.io.SVGInputFormat;

public class SVGZInputFormat
extends SVGInputFormat {
    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Scalable Vector Graphics (SVG, SVGZ)", new String[]{"svg", "svgz"});
    }

    @Override
    public void read(InputStream in, Drawing drawing, boolean replace) throws IOException {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        bin.mark(2);
        int magic = bin.read() & 0xFF | (bin.read() & 0xFF) << 8;
        bin.reset();
        if (magic == 35615) {
            super.read(new GZIPInputStream(bin), drawing, replace);
        } else {
            super.read(bin, drawing, replace);
        }
    }
}

