/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.web.WebView;
import org.scijava.Context;
import sc.fiji.filamentdetector.gui.controller.AbstractController;

public class AboutController
extends AbstractController
implements Initializable {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/AboutView.fxml";
    @FXML
    private WebView aboutTextField;

    public AboutController(Context context) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.aboutTextField.setContextMenuEnabled(false);
        this.loadAboutText();
    }

    private void loadAboutText() {
        String text = "<h1><a></a>About FilamentDetector</h1>\n<p>The <strong>detection</strong> step is based on the ImageJ1 implementation of Steger, 1998 (<a href=\"http://imagej.net/Ridge_Detection\">http://imagej.net/Ridge_Detection</a>). The <strong>tracking</strong> step is based on the Jaqaman tracking algorithm (Jaqaman, 2008) implemented in <a href=\"https://imagej.net/TrackMate\">TrackMate</a>. Instead of using the euclidean distance as a cost function, <strong>FilamentDetector</strong> usez the bounding boxes of the detected filaments to compute the <a href=\"https://en.wikipedia.org/wiki/Jaccard_index\">Intersection over Union</a>.</p>\n<ul>\n<li>Source code: <a href=\"https://github.com/fiji/FilamentDetector\">https://github.com/fiji/FilamentDetector</a></li>\n<li>Report an issue: <a href=\"https://github.com/fiji/FilamentDetector/issues\">https://github.com/fiji/FilamentDetector/issues</a></li>\n<li>Wiki: <a href=\"http://imagej.net/FilamentDetector\">http://imagej.net/FilamentDetector</a></li>\n</ul>";
        this.aboutTextField.getEngine().loadContent(text);
    }
}

