/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller.detection;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.scijava.Context;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.detection.IJ2RidgeDetectionFilamentDetector;
import sc.fiji.filamentdetector.gui.controller.detection.AbstractFilamentDetectorController;
import sc.fiji.filamentdetector.gui.event.DetectionParametersUpdatedEvent;
import sc.fiji.filamentdetector.gui.fxwidgets.SliderLabelSynchronizer;
import sc.fiji.filamentdetector.gui.fxwidgets.UpperLowerSynchronizer;

public class IJ2RidgeDetectionFilamentDetectorController
extends AbstractFilamentDetectorController {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/detection/IJ2RidgeDetectionFilamentDetectorView.fxml";
    @Parameter
    private EventService eventService;
    @FXML
    private Slider lineWidthSlider;
    @FXML
    private TextField lineWidthField;
    @FXML
    private Slider lowerThresholdSlider;
    @FXML
    private TextField lowerThresholdField;
    @FXML
    private Slider upperThresholdSlider;
    @FXML
    private TextField upperThresholdField;
    private UpperLowerSynchronizer thresholdSync;
    private SliderLabelSynchronizer lineWidthSync;
    private IJ2RidgeDetectionFilamentDetector filamentDetector;

    public IJ2RidgeDetectionFilamentDetectorController(Context context, FilamentDetector filamentDetector) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentDetector = (IJ2RidgeDetectionFilamentDetector)filamentDetector;
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.thresholdSync = new UpperLowerSynchronizer(this.lowerThresholdSlider, this.lowerThresholdField, this.upperThresholdSlider, this.upperThresholdField);
        this.thresholdSync.setLowerTooltip("Line points with a response smaller as this threshold are rejected.");
        this.thresholdSync.setUpperTooltip("Line points with a response larger as this threshold are accepted.");
        this.thresholdSync.setLowerValue(this.filamentDetector.getLowerThreshold());
        this.thresholdSync.setUpperValue(this.filamentDetector.getUpperThreshold());
        this.lineWidthSync = new SliderLabelSynchronizer(this.lineWidthSlider, this.lineWidthField);
        this.lineWidthSync.setTooltip("The line diameter in pixels. It estimates the parameter \"sigma\" (available in the \"Advanced\" tab).");
        this.lineWidthSync.setValue(this.filamentDetector.getLineWidth());
    }

    @FXML
    public void updateParameters(Event event) {
        if (this.thresholdSync.isEvent(event)) {
            this.thresholdSync.update(event);
            this.filamentDetector.setLowerThreshold(this.thresholdSync.getLowerValue());
            this.filamentDetector.setUpperThreshold(this.thresholdSync.getUpperValue());
        } else if (this.lineWidthSync.isEvent(event)) {
            this.lineWidthSync.update(event);
            this.filamentDetector.setLineWidth(this.lineWidthSync.getValue());
        }
        this.eventService.publish((SciJavaEvent)new DetectionParametersUpdatedEvent());
    }
}

