/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BHInsertStructure;
import org.scijava.java3d.BHNode;
import org.scijava.java3d.BoundingBox;

class BHInternalNode
extends BHNode {
    static boolean debug2 = true;
    BHNode rChild;
    BHNode lChild;

    BHInternalNode() {
        this.nodeType = 1;
        this.rChild = null;
        this.lChild = null;
    }

    BHInternalNode(BHNode parent) {
        super(parent);
        this.nodeType = 1;
        this.rChild = null;
        this.lChild = null;
    }

    BHInternalNode(BHNode parent, BHNode rChild, BHNode lChild) {
        super(parent);
        this.nodeType = 1;
        this.rChild = rChild;
        this.lChild = lChild;
    }

    BHInternalNode(BHNode parent, BoundingBox bHull) {
        super(parent, bHull);
        this.nodeType = 1;
        this.rChild = null;
        this.lChild = null;
    }

    BHInternalNode(BHNode parent, BHNode rChild, BHNode lChild, BoundingBox bHull) {
        super(parent, bHull);
        this.nodeType = 1;
        this.rChild = rChild;
        this.lChild = lChild;
    }

    BHNode getLeftChild() {
        return this.lChild;
    }

    BHNode getRightChild() {
        return this.rChild;
    }

    void setLeftChild(BHNode child) {
        this.lChild = child;
    }

    void setRightChild(BHNode child) {
        this.rChild = child;
    }

    void computeBoundingHull(BoundingBox bHull) {
        this.computeBoundingHull();
        bHull.set(this.bHull);
    }

    @Override
    void computeBoundingHull() {
        BoundingBox rChildBound = null;
        BoundingBox lChildBound = null;
        if (this.lChild == null && this.rChild == null) {
            this.bHull = null;
            return;
        }
        if (this.lChild != null) {
            lChildBound = this.lChild.getBoundingHull();
        }
        if (this.rChild != null) {
            rChildBound = this.rChild.getBoundingHull();
        }
        if (this.bHull == null) {
            this.bHull = new BoundingBox();
        }
        if (this.lChild == null) {
            this.bHull.set(rChildBound);
            return;
        }
        if (this.rChild == null) {
            this.bHull.set(lChildBound);
            return;
        }
        this.bHull.set(rChildBound);
        this.bHull.combine(lChildBound);
    }

    @Override
    void updateMarkedBoundingHull() {
        if (!this.mark) {
            return;
        }
        this.rChild.updateMarkedBoundingHull();
        this.lChild.updateMarkedBoundingHull();
        this.computeBoundingHull();
        this.mark = false;
    }

    void insert(BHNode node, BHInsertStructure insertStructure) {
        if (debug2 && !this.isInside(node.bHull)) {
            System.err.println("Incorrect use of insertion, current node");
            System.err.println("must contain the input element ...");
        }
        boolean insideRightChild = false;
        boolean insideLeftChild = false;
        insideRightChild = this.rChild.nodeType == 2 ? false : this.rChild.isInside(node.bHull);
        insideLeftChild = this.lChild.nodeType == 2 ? false : this.lChild.isInside(node.bHull);
        if (insideLeftChild && !insideRightChild) {
            ((BHInternalNode)this.lChild).insert(node, insertStructure);
        } else if (!insideLeftChild && insideRightChild) {
            ((BHInternalNode)this.rChild).insert(node, insertStructure);
        } else if (insideLeftChild && insideRightChild) {
            if (insertStructure.randomNumber.nextBoolean()) {
                ((BHInternalNode)this.lChild).insert(node, insertStructure);
            } else {
                ((BHInternalNode)this.rChild).insert(node, insertStructure);
            }
        } else {
            insertStructure.lookupAndInsert(this, node);
        }
    }

    @Override
    void destroyTree(BHNode[] bhArr, int[] index) {
        if (this.rChild != null) {
            this.rChild.destroyTree(bhArr, index);
        }
        if (this.lChild != null) {
            this.lChild.destroyTree(bhArr, index);
        }
        this.rChild = null;
        this.lChild = null;
    }
}

