/*
 * Decompiled with CFR 0.152.
 */
package bdv.spimdata.tools;

import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;

public class MergeTools {
    public static SpimDataMinimal merge(File basePath, SpimDataMinimal ... spimDatas) {
        return MergeTools.merge(basePath, new ArrayList<SpimDataMinimal>(Arrays.asList(spimDatas)));
    }

    public static SpimDataMinimal merge(File basePath, ArrayList<SpimDataMinimal> spimDatas) {
        HashMap aggregateTpIds = new HashMap();
        for (SpimDataMinimal spimDataMinimal : spimDatas) {
            SequenceDescriptionMinimal sequenceDescriptionMinimal = (SequenceDescriptionMinimal)spimDataMinimal.getSequenceDescription();
            Map map = sequenceDescriptionMinimal.getTimePoints().getTimePoints();
            aggregateTpIds.putAll(map);
        }
        TimePoints aggregateTimepoints = new TimePoints(aggregateTpIds);
        for (SpimDataMinimal spimDataMinimal : spimDatas) {
            SequenceDescriptionMinimal sequenceDescriptionMinimal = (SequenceDescriptionMinimal)spimDataMinimal.getSequenceDescription();
            Map map = sequenceDescriptionMinimal.getTimePoints().getTimePoints();
            if (!aggregateTpIds.keySet().equals(map.keySet())) continue;
            aggregateTimepoints = sequenceDescriptionMinimal.getTimePoints();
        }
        HashMap hashMap = new HashMap();
        for (SpimDataMinimal spimDataMinimal : spimDatas) {
            SequenceDescriptionMinimal sequenceDescriptionMinimal = (SequenceDescriptionMinimal)spimDataMinimal.getSequenceDescription();
            Map setups = sequenceDescriptionMinimal.getViewSetups();
            hashMap.putAll(setups);
        }
        HashMap<ViewRegistration, ViewRegistration> hashMap2 = new HashMap<ViewRegistration, ViewRegistration>();
        for (SpimDataMinimal spimDataMinimal : spimDatas) {
            for (Object reg : spimDataMinimal.getViewRegistrations().getViewRegistrationsOrdered()) {
                if (hashMap2.put((ViewRegistration)reg, (ViewRegistration)reg) == null) continue;
                throw new IllegalArgumentException("Error: setup " + reg.getViewSetupId() + " timepoint " + reg.getTimePointId() + " present in multiple sequences!");
            }
        }
        ArrayList<ViewId> arrayList = new ArrayList<ViewId>();
        for (BasicViewSetup setup : hashMap.values()) {
            for (TimePoint timepoint : aggregateTimepoints.getTimePointsOrdered()) {
                ViewId viewId = new ViewId(timepoint.getId(), setup.getId());
                if (hashMap2.containsKey(viewId)) continue;
                arrayList.add(viewId);
            }
        }
        MissingViews missingViews = new MissingViews(arrayList);
        ViewRegistrations aggregateViewRegistrations = new ViewRegistrations(hashMap2.values());
        BasicImgLoader imgLoader = null;
        SequenceDescriptionMinimal aggregateSequenceDescription = new SequenceDescriptionMinimal(aggregateTimepoints, hashMap, imgLoader, missingViews);
        SpimDataMinimal aggregateSpimData = new SpimDataMinimal(basePath, aggregateSequenceDescription, aggregateViewRegistrations);
        return aggregateSpimData;
    }
}

