/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.SetupAssignments;
import bdv.util.AbstractSource;
import bdv.util.BdvHandle;
import bdv.util.BdvSource;
import bdv.util.Bounds;
import bdv.viewer.ConverterSetupBounds;
import bdv.viewer.SourceAndConverter;
import java.util.HashSet;
import java.util.List;
import net.imglib2.type.numeric.ARGBType;

public class BdvStackSource<T>
extends BdvSource {
    private final T type;
    private final List<ConverterSetup> converterSetups;
    private final List<SourceAndConverter<T>> sources;

    protected BdvStackSource(BdvHandle bdv, int numTimepoints, T type, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        super(bdv, numTimepoints);
        this.type = AbstractSource.tryCreateVariable(type);
        this.converterSetups = converterSetups;
        this.sources = sources;
    }

    @Override
    public void removeFromBdv() {
        this.getBdvHandle().remove(this.converterSetups, this.sources, null, null, null, null);
        this.getBdvHandle().removeBdvSource(this);
    }

    @Override
    protected boolean isPlaceHolderSource() {
        return false;
    }

    @Override
    public void setColor(ARGBType color) {
        for (ConverterSetup setup : this.converterSetups) {
            setup.setColor(color);
        }
    }

    @Override
    public void setDisplayRange(double min, double max) {
        for (ConverterSetup setup : this.converterSetups) {
            setup.setDisplayRange(min, max);
        }
    }

    @Override
    public void setDisplayRangeBounds(double min, double max) {
        ConverterSetupBounds bounds = this.getBdvHandle().getConverterSetups().getBounds();
        for (ConverterSetup setup : this.converterSetups) {
            bounds.setBounds(setup, new Bounds(min, max));
        }
        HashSet<MinMaxGroup> groups = new HashSet<MinMaxGroup>();
        SetupAssignments sa = this.getBdvHandle().getSetupAssignments();
        for (ConverterSetup setup : this.converterSetups) {
            groups.add(sa.getMinMaxGroup(setup));
        }
        for (MinMaxGroup group : groups) {
            group.setRange(min, max);
        }
    }

    @Override
    public void setCurrent() {
        this.getBdvHandle().getViewerPanel().state().setCurrentSource(this.sources.get(0));
    }

    @Override
    public boolean isCurrent() {
        return this.sources.contains(this.getBdvHandle().getViewerPanel().state().getCurrentSource());
    }

    @Override
    public void setActive(boolean isActive) {
        this.getBdvHandle().getViewerPanel().state().setSourcesActive(this.sources, isActive);
    }

    public List<ConverterSetup> getConverterSetups() {
        return this.converterSetups;
    }

    public List<SourceAndConverter<T>> getSources() {
        return this.sources;
    }
}

