/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.BdvOverlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.realtransform.AffineTransform3D;

public class PointsOverlay
extends BdvOverlay {
    private List<? extends RealLocalizable> points;
    private Color col;

    public <T extends RealLocalizable> void setPoints(List<T> points) {
        this.points = points;
    }

    @Override
    protected void draw(Graphics2D graphics) {
        if (this.points == null) {
            return;
        }
        this.col = new Color(this.info.getColor().get());
        AffineTransform3D transform = new AffineTransform3D();
        this.getCurrentTransform3D(transform);
        double[] lPos = new double[3];
        double[] gPos = new double[3];
        for (RealLocalizable realLocalizable : this.points) {
            realLocalizable.localize(lPos);
            transform.apply(lPos, gPos);
            double size = this.getPointSize(gPos);
            int x = (int)(gPos[0] - 0.5 * size);
            int y = (int)(gPos[1] - 0.5 * size);
            int w = (int)size;
            graphics.setColor(this.getColor(gPos));
            graphics.fillOval(x, y, w, w);
        }
    }

    private Color getColor(double[] gPos) {
        int alpha = 255 - (int)Math.round(Math.abs(gPos[2]));
        if (alpha < 64) {
            alpha = 64;
        }
        return new Color(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), alpha);
    }

    private double getPointSize(double[] gPos) {
        if (Math.abs(gPos[2]) < 3.0) {
            return 5.0;
        }
        return 3.0;
    }
}

