/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.viewer.animate.AbstractAnimator;
import bdv.viewer.animate.OverlayAnimator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class TextOverlayAnimator
extends AbstractAnimator
implements OverlayAnimator {
    protected final Font font;
    protected final String text;
    protected final double fadeInTime;
    protected final double fadeOutTime;
    protected final TextPosition position;

    public TextOverlayAnimator(String text, long duration) {
        this(text, duration, TextPosition.BOTTOM_RIGHT);
    }

    public TextOverlayAnimator(String text, long duration, TextPosition position) {
        this(text, duration, position, 0.2, 0.5);
    }

    public TextOverlayAnimator(String text, long duration, TextPosition position, double fadeInTime, double fadeOutTime) {
        this(text, duration, position, fadeInTime, fadeOutTime, new Font("SansSerif", 1, 20));
    }

    public TextOverlayAnimator(String text, long duration, TextPosition position, double fadeInTime, double fadeOutTime, Font font) {
        super(duration);
        this.text = text;
        this.font = font;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
        this.position = position;
    }

    @Override
    public void paint(Graphics2D g, long time) {
        float y;
        float x;
        this.setTime(time);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(this.text, this.font, frc);
        Rectangle2D bounds = layout.getBounds();
        if (this.position == TextPosition.BOTTOM_RIGHT) {
            x = (float)(g.getClipBounds().getWidth() - bounds.getWidth() - 10.0);
            y = (float)(g.getClipBounds().getHeight() - 10.0);
        } else {
            x = (float)(g.getClipBounds().getWidth() - bounds.getWidth()) / 2.0f;
            y = (float)(g.getClipBounds().getHeight() - bounds.getHeight()) / 2.0f;
        }
        double t = this.ratioComplete();
        float alpha = t <= this.fadeInTime ? (float)Math.sin(1.5707963267948966 * t / this.fadeInTime) : (t >= 1.0 - this.fadeOutTime ? (float)Math.sin(1.5707963267948966 * (1.0 - t) / this.fadeOutTime) : 1.0f);
        g.setColor(new Color(1.0f, 1.0f, 1.0f, alpha));
        layout.draw(g, x, y);
    }

    @Override
    public boolean requiresRepaint() {
        return !this.isComplete();
    }

    public static enum TextPosition {
        CENTER,
        BOTTOM_RIGHT;

    }
}

