/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import net.imglib2.type.label.ByteUtils;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.MappedAccess;

public class LongMappedAccess
implements MappedAccess<LongMappedAccess> {
    private long baseOffset;
    private LongMappedAccessData dataArray;
    private long[] swapTmp = new long[0];

    LongMappedAccess(LongMappedAccessData dataArray, long baseOffset) {
        this.dataArray = dataArray;
        this.baseOffset = baseOffset;
    }

    void setDataArray(LongMappedAccessData dataArray) {
        this.dataArray = dataArray;
    }

    void setBaseOffset(long baseOffset) {
        this.baseOffset = baseOffset;
    }

    @Override
    public void putByte(byte value, int offset) {
        ByteUtils.putByte(value, this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public byte getByte(int offset) {
        return ByteUtils.getByte(this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public void putBoolean(boolean value, int offset) {
        ByteUtils.putBoolean(value, this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public boolean getBoolean(int offset) {
        return ByteUtils.getBoolean(this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public void putInt(int value, int offset) {
        ByteUtils.putInt(value, this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public int getInt(int offset) {
        return ByteUtils.getInt(this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public void putLong(long value, int offset) {
        ByteUtils.putLong(value, this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public long getLong(int offset) {
        return ByteUtils.getLong(this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public void putFloat(float value, int offset) {
        ByteUtils.putFloat(value, this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public float getFloat(int offset) {
        return ByteUtils.getFloat(this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public void putDouble(double value, int offset) {
        ByteUtils.putDouble(value, this.dataArray.data, this.baseOffset + (long)offset);
    }

    @Override
    public double getDouble(int offset) {
        return ByteUtils.getDouble(this.dataArray.data, this.baseOffset + (long)offset);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongMappedAccess) {
            LongMappedAccess e = (LongMappedAccess)obj;
            return e.dataArray == this.dataArray && e.baseOffset == this.baseOffset;
        }
        return false;
    }

    public int hashCode() {
        return this.dataArray.hashCode() + (int)(this.baseOffset & 0xFFFFL);
    }

    @Override
    public void copyFrom(LongMappedAccess fromAccess, int numBytes) {
        ByteUtils.copyBytes(fromAccess.dataArray.data, fromAccess.baseOffset, this.dataArray.data, this.baseOffset, numBytes);
    }

    @Override
    public void swapWith(LongMappedAccess access, int numBytes) {
        if (this.swapTmp.length << 3 < numBytes) {
            this.swapTmp = new long[(numBytes >> 3) + 1];
        }
        ByteUtils.copyBytes(this.dataArray.data, this.baseOffset, this.swapTmp, 0L, numBytes);
        ByteUtils.copyBytes(access.dataArray.data, access.baseOffset, this.dataArray.data, this.baseOffset, numBytes);
        ByteUtils.copyBytes(this.swapTmp, 0L, access.dataArray.data, access.baseOffset, numBytes);
    }
}

