/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.ByteVector;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;

public class Base64Codec
extends BaseCodec {
    private static final byte PAD = 61;
    private static byte[] base64Alphabet;
    private static byte[] lookupBase64Alphabet;

    @Override
    public byte[] compress(byte[] input, CodecOptions options) throws CodecException {
        byte k;
        byte l;
        byte b2;
        byte b1;
        if (input == null || input.length == 0) {
            return null;
        }
        int dataBits = input.length * 8;
        int fewerThan24 = dataBits % 24;
        int numTriples = dataBits / 24;
        ByteVector encoded = new ByteVector();
        int dataIndex = 0;
        for (int i = 0; i < numTriples; ++i) {
            dataIndex = i * 3;
            b1 = input[dataIndex];
            b2 = input[dataIndex + 1];
            byte b3 = input[dataIndex + 2];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            byte v1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte v2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte v3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encoded.add(lookupBase64Alphabet[v1]);
            encoded.add(lookupBase64Alphabet[v2 | k << 4]);
            encoded.add(lookupBase64Alphabet[l << 2 | v3]);
            encoded.add(lookupBase64Alphabet[b3 & 0x3F]);
        }
        dataIndex = numTriples * 3;
        if (fewerThan24 == 8) {
            b1 = input[dataIndex];
            k = (byte)(b1 & 3);
            byte v = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            encoded.add(lookupBase64Alphabet[v]);
            encoded.add(lookupBase64Alphabet[k << 4]);
            encoded.add((byte)61);
            encoded.add((byte)61);
        } else if (fewerThan24 == 16) {
            b1 = input[dataIndex];
            b2 = input[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            byte v1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte v2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            encoded.add(lookupBase64Alphabet[v1]);
            encoded.add(lookupBase64Alphabet[v2 | k << 4]);
            encoded.add(lookupBase64Alphabet[l << 2]);
            encoded.add((byte)61);
        }
        return encoded.toByteArray();
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (in.length() == 0L) {
            return new byte[0];
        }
        byte b3 = 0;
        byte b4 = 0;
        byte marker0 = 0;
        byte marker1 = 0;
        ByteVector decodedData = new ByteVector();
        byte[] block = new byte[8192];
        int nRead = in.read(block);
        int p = 0;
        byte b1 = base64Alphabet[block[p++]];
        byte b2 = base64Alphabet[block[p++]];
        while (b1 != -1 && b2 != -1 && in.getFilePointer() - (long)nRead + (long)p < in.length()) {
            marker0 = block[p++];
            marker1 = block[p++];
            if (p == block.length) {
                nRead = in.read(block);
                p = 0;
            }
            decodedData.add((byte)(b1 << 2 | b2 >> 4));
            if (marker0 != 61 && marker1 != 61) {
                b3 = base64Alphabet[marker0];
                b4 = base64Alphabet[marker1];
                decodedData.add((byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF));
                decodedData.add((byte)(b3 << 6 | b4));
            } else if (marker0 != 61 && marker1 == 61) {
                b3 = base64Alphabet[marker0];
                decodedData.add((byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF));
            }
            if (p >= nRead && in.getFilePointer() >= in.length()) break;
            b1 = base64Alphabet[block[p++]];
            b2 = base64Alphabet[block[p++]];
        }
        return decodedData.toByteArray();
    }

    static {
        int i;
        base64Alphabet = new byte[255];
        lookupBase64Alphabet = new byte[255];
        for (i = 0; i < 255; ++i) {
            Base64Codec.base64Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base64Codec.base64Alphabet[i] = (byte)(i - 65);
            Base64Codec.lookupBase64Alphabet[i - 65] = (byte)i;
        }
        for (i = 122; i >= 97; --i) {
            Base64Codec.base64Alphabet[i] = (byte)(i - 97 + 26);
            Base64Codec.lookupBase64Alphabet[i - 97 + 26] = (byte)i;
        }
        for (i = 57; i >= 48; --i) {
            Base64Codec.base64Alphabet[i] = (byte)(i - 48 + 52);
            Base64Codec.lookupBase64Alphabet[i - 48 + 52] = (byte)i;
        }
        Base64Codec.base64Alphabet[43] = 62;
        Base64Codec.base64Alphabet[47] = 63;
        Base64Codec.lookupBase64Alphabet[62] = 43;
        Base64Codec.lookupBase64Alphabet[63] = 47;
    }
}

