/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.process.ImageProcessor;
import mpicbg.ij.InvertibleMapping;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class InvertibleTransformMapping<T extends InvertibleCoordinateTransform>
implements InvertibleMapping<T> {
    protected final T transform;

    @Override
    public final T getTransform() {
        return this.transform;
    }

    public InvertibleTransformMapping(T t) {
        this.transform = t;
    }

    @Override
    public void map(ImageProcessor source, ImageProcessor target) {
        double[] t = new double[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                try {
                    this.transform.applyInverseInPlace(t);
                    int tx = (int)(t[0] + 0.5);
                    int ty = (int)(t[1] + 0.5);
                    if (!(t[0] >= 0.0) || !(t[0] <= (double)sw) || !(t[1] >= 0.0) || !(t[1] <= (double)sh)) continue;
                    target.putPixel(x, y, source.getPixel(tx, ty));
                    continue;
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mapInterpolated(ImageProcessor source, ImageProcessor target) {
        double[] t = new double[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                try {
                    this.transform.applyInverseInPlace(t);
                    if (!(t[0] >= 0.0) || !(t[0] <= (double)sw) || !(t[1] >= 0.0) || !(t[1] <= (double)sh)) continue;
                    target.putPixel(x, y, source.getPixelInterpolated(t[0], t[1]));
                    continue;
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mapInverse(ImageProcessor source, ImageProcessor target) {
        double[] t = new double[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                this.transform.applyInPlace(t);
                int tx = (int)(t[0] + 0.5);
                int ty = (int)(t[1] + 0.5);
                if (!(t[0] >= 0.0) || !(t[0] <= (double)sw) || !(t[1] >= 0.0) || !(t[1] <= (double)sh)) continue;
                target.putPixel(x, y, source.getPixel(tx, ty));
            }
        }
    }

    @Override
    public void mapInverseInterpolated(ImageProcessor source, ImageProcessor target) {
        double[] t = new double[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                this.transform.applyInPlace(t);
                if (!(t[0] >= 0.0) || !(t[0] < (double)sw) || !(t[1] >= 0.0) || !(t[1] < (double)sh)) continue;
                target.putPixel(x, y, source.getPixelInterpolated(t[0], t[1]));
            }
        }
    }
}

