/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class Point
implements Serializable {
    private static final long serialVersionUID = -5885773585629275552L;
    protected final double[] w;
    protected final double[] l;

    public double[] getW() {
        return this.w;
    }

    public double[] getL() {
        return this.l;
    }

    public Point(double[] l, double[] w) {
        assert (l.length == w.length) : "Local and world coordinates have to have the same dimensionality.";
        this.l = l;
        this.w = w;
    }

    public Point(double[] l) {
        this(l, (double[])l.clone());
    }

    public final void apply(CoordinateTransform t) {
        System.arraycopy(this.l, 0, this.w, 0, this.l.length);
        t.applyInPlace(this.w);
    }

    public final void apply(CoordinateTransform t, double amount) {
        double[] a = t.apply(this.l);
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            this.w[n] = this.w[n] + amount * (a[i] - this.w[i]);
        }
    }

    public final void applyInverse(InverseCoordinateTransform t) throws NoninvertibleModelException {
        System.arraycopy(this.l, 0, this.w, 0, this.l.length);
        t.applyInverseInPlace(this.w);
    }

    public double squareDistance() {
        double sum = 0.0;
        for (int i = 0; i < this.l.length; ++i) {
            double d = this.w[i] - this.l[i];
            sum += d * d;
        }
        return sum;
    }

    public double distance() {
        return Math.sqrt(this.squareDistance());
    }

    public static final double squareDistance(Point p1, Point p2) {
        assert (p1.w.length == p2.w.length) : "Both points have to have the same number of dimensions.";
        double sum = 0.0;
        for (int i = 0; i < p1.w.length; ++i) {
            double d = p1.w[i] - p2.w[i];
            sum += d * d;
        }
        return sum;
    }

    public static final double distance(Point p1, Point p2) {
        assert (p1.w.length == p2.w.length) : "Both points have to have the same number of dimensions.";
        return Math.sqrt(Point.squareDistance(p1, p2));
    }

    public static final double squareLocalDistance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same number of dimensions.";
        double sum = 0.0;
        for (int i = 0; i < p1.l.length; ++i) {
            double d = p1.l[i] - p2.l[i];
            sum += d * d;
        }
        return sum;
    }

    public static final double localDistance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same number of dimensions.";
        return Math.sqrt(Point.squareLocalDistance(p1, p2));
    }

    public Point clone() {
        Point p = new Point((double[])this.l.clone());
        for (int i = 0; i < this.w.length; ++i) {
            p.w[i] = this.w[i];
        }
        return p;
    }

    public static <P extends Point> void apply(CoordinateTransform t, Iterable<P> points) {
        for (Point p : points) {
            p.apply(t);
        }
    }

    public static void applyInverse(InverseCoordinateTransform t, Iterable<Point> points) throws NoninvertibleModelException {
        for (Point p : points) {
            p.applyInverse(t);
        }
    }
}

