/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.AppearanceRetained;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.EnvironmentSet;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.RenderBin;
import org.jogamp.java3d.RenderingAttributesRetained;
import org.jogamp.java3d.ShaderAppearanceRetained;
import org.jogamp.java3d.ShaderBin;
import org.jogamp.java3d.VirtualUniverse;

class AttributeBin
implements ObjectUpdate {
    RenderingAttributesRetained definingRenderingAttributes = null;
    RenderBin renderBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin next = null;
    AttributeBin prev = null;
    ShaderBin shaderBinList = null;
    ArrayList<ShaderBin> addShaderBins = new ArrayList();
    boolean soleUser = false;
    AppearanceRetained app = null;
    int onUpdateList = 0;
    static int ON_OBJ_UPDATE_LIST = 1;
    static int ON_CHANGED_FREQUENT_UPDATE_LIST = 2;
    boolean ignoreVertexColors = false;
    RenderingAttributesRetained renderingAttrs;
    int numEditingShaderBins = 0;

    AttributeBin(AppearanceRetained app, RenderingAttributesRetained renderingAttributes, RenderBin rBin) {
        this.reset(app, renderingAttributes, rBin);
    }

    void reset(AppearanceRetained app, RenderingAttributesRetained renderingAttributes, RenderBin rBin) {
        this.prev = null;
        this.next = null;
        this.shaderBinList = null;
        this.onUpdateList = 0;
        this.numEditingShaderBins = 0;
        this.renderingAttrs = renderingAttributes;
        this.renderBin = rBin;
        this.soleUser = false;
        if (VirtualUniverse.mc.allowSoleUser && app != null) {
            boolean bl = this.soleUser = (app.changedFrequent & 0x40) != 0;
        }
        if (this.soleUser) {
            this.app = app;
        } else {
            app = null;
        }
        if (renderingAttributes != null) {
            if (renderingAttributes.changedFrequent != 0) {
                this.definingRenderingAttributes = renderingAttributes;
                if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) == 0) {
                    this.renderBin.aBinUpdateList.add(this);
                    this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
                }
            } else if (this.definingRenderingAttributes != null) {
                this.definingRenderingAttributes.set(renderingAttributes);
            } else {
                this.definingRenderingAttributes = (RenderingAttributesRetained)renderingAttributes.clone();
            }
            this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
        } else {
            this.definingRenderingAttributes = null;
            this.ignoreVertexColors = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean equals(RenderingAttributesRetained renderingAttributes, RenderAtom ra) {
        if (this.soleUser || ra.geometryAtom.source.appearance != null && (ra.geometryAtom.source.appearance.changedFrequent & 0x40) != 0) {
            if (this.app != ra.geometryAtom.source.appearance) return false;
            if (this.numEditingShaderBins != 0) return true;
            if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) return true;
            this.renderBin.aBinUpdateList.add(this);
            this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
            return true;
        }
        if (this.definingRenderingAttributes == null) {
            if (renderingAttributes == null) return true;
            return false;
        }
        if (this.definingRenderingAttributes.changedFrequent != 0 || renderingAttributes != null && renderingAttributes.changedFrequent != 0) {
            if (this.definingRenderingAttributes != renderingAttributes) return false;
            if (this.definingRenderingAttributes.compChanged == 0) return true;
            if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) return true;
            this.renderBin.aBinUpdateList.add(this);
            this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
            return true;
        }
        if (this.definingRenderingAttributes.equivalent(renderingAttributes)) return true;
        return false;
    }

    @Override
    public void updateObject() {
        int size = this.addShaderBins.size();
        if (size > 0) {
            ShaderBin sb = this.addShaderBins.get(0);
            if (this.shaderBinList == null) {
                this.shaderBinList = sb;
            } else {
                sb.next = this.shaderBinList;
                this.shaderBinList.prev = sb;
                this.shaderBinList = sb;
            }
            for (int i = 1; i < size; ++i) {
                sb = this.addShaderBins.get(i);
                sb.next = this.shaderBinList;
                this.shaderBinList.prev = sb;
                this.shaderBinList = sb;
            }
        }
        this.addShaderBins.clear();
        this.onUpdateList &= ~ON_OBJ_UPDATE_LIST;
    }

    void addShaderBin(ShaderBin sb, RenderBin rb, ShaderAppearanceRetained sApp) {
        sb.attributeBin = this;
        if (sApp != null) {
            assert (sApp.isMirror);
            sb.shaderProgram = sApp.shaderProgram;
            sb.shaderAttributeSet = sApp.shaderAttributeSet;
        }
        sb.shaderAppearance = sApp;
        this.addShaderBins.add(sb);
        if ((this.onUpdateList & ON_OBJ_UPDATE_LIST) == 0) {
            this.onUpdateList |= ON_OBJ_UPDATE_LIST;
            rb.objUpdateList.add(this);
        }
    }

    void removeShaderBin(ShaderBin sb) {
        if (this.addShaderBins.contains(sb)) {
            this.addShaderBins.remove(this.addShaderBins.indexOf(sb));
        } else if (sb.prev == null) {
            this.shaderBinList = sb.next;
            if (sb.next != null) {
                sb.next.prev = null;
            }
        } else {
            sb.prev.next = sb.next;
            if (sb.next != null) {
                sb.next.prev = sb.prev;
            }
        }
        sb.clear();
        if (this.shaderBinList == null && this.addShaderBins.size() == 0) {
            this.environmentSet.removeAttributeBin(this);
        }
    }

    void render(Canvas3D cv) {
        boolean visible;
        boolean bl = visible = this.definingRenderingAttributes == null || this.definingRenderingAttributes.visible;
        if (this.renderBin.view.viewCache.visibilityPolicy == 0 && !visible || this.renderBin.view.viewCache.visibilityPolicy == 1 && visible) {
            return;
        }
        cv.setStateToUpdate(2, this);
        ShaderBin sb = this.shaderBinList;
        while (sb != null) {
            sb.render(cv);
            sb = sb.next;
        }
    }

    void updateAttributes(Canvas3D cv) {
        if ((cv.canvasDirty & 0x200) != 0) {
            if (this.definingRenderingAttributes == null) {
                cv.resetRenderingAttributes(cv.ctx, cv.depthBufferWriteEnableOverride, cv.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(cv, cv.depthBufferWriteEnableOverride, cv.depthBufferEnableOverride);
            }
            cv.renderingAttrs = this.renderingAttrs;
        } else if (cv.renderingAttrs != this.renderingAttrs && cv.attributeBin != this) {
            if (this.definingRenderingAttributes == null) {
                cv.resetRenderingAttributes(cv.ctx, cv.depthBufferWriteEnableOverride, cv.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(cv, cv.depthBufferWriteEnableOverride, cv.depthBufferEnableOverride);
            }
            cv.renderingAttrs = this.renderingAttrs;
        }
        cv.attributeBin = this;
        cv.canvasDirty &= 0xFFFFFDFF;
    }

    void updateNodeComponent() {
        if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) {
            if (this.soleUser) {
                boolean cloned = this.definingRenderingAttributes != null && this.definingRenderingAttributes != this.renderingAttrs;
                this.renderingAttrs = this.app.renderingAttributes;
                if (this.renderingAttrs == null) {
                    this.definingRenderingAttributes = null;
                    this.ignoreVertexColors = false;
                } else {
                    if (this.renderingAttrs.changedFrequent != 0) {
                        this.definingRenderingAttributes = this.renderingAttrs;
                    } else if (cloned) {
                        this.definingRenderingAttributes.set(this.renderingAttrs);
                    } else {
                        this.definingRenderingAttributes = (RenderingAttributesRetained)this.renderingAttrs.clone();
                    }
                    this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
                }
            } else {
                this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
            }
        }
        this.onUpdateList &= ~ON_CHANGED_FREQUENT_UPDATE_LIST;
    }

    void incrActiveShaderBin() {
        ++this.numEditingShaderBins;
    }

    void decrActiveShaderBin() {
        --this.numEditingShaderBins;
    }

    void updateFromShaderBin(RenderAtom ra) {
        RenderingAttributesRetained rAttrs;
        AppearanceRetained raApp = ra.geometryAtom.source.appearance;
        RenderingAttributesRetained renderingAttributesRetained = rAttrs = raApp == null ? null : raApp.renderingAttributes;
        if (!this.soleUser && this.renderingAttrs != rAttrs) {
            this.renderingAttrs = this.definingRenderingAttributes;
        }
    }
}

