/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.PolygonAttributesRetained;

public class PolygonAttributes
extends NodeComponent {
    public static final int ALLOW_CULL_FACE_READ = 0;
    public static final int ALLOW_CULL_FACE_WRITE = 1;
    public static final int ALLOW_NORMAL_FLIP_READ = 6;
    public static final int ALLOW_NORMAL_FLIP_WRITE = 7;
    public static final int ALLOW_MODE_READ = 2;
    public static final int ALLOW_MODE_WRITE = 3;
    public static final int ALLOW_OFFSET_READ = 4;
    public static final int ALLOW_OFFSET_WRITE = 5;
    public static final int POLYGON_POINT = 0;
    public static final int POLYGON_LINE = 1;
    public static final int POLYGON_FILL = 2;
    public static final int CULL_NONE = 0;
    public static final int CULL_BACK = 1;
    public static final int CULL_FRONT = 2;
    private static final int[] readCapabilities = new int[]{0, 2, 6, 4};

    public PolygonAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public PolygonAttributes(int polygonMode, int cullFace, float polygonOffset) {
        this(polygonMode, cullFace, polygonOffset, false, 0.0f);
    }

    public PolygonAttributes(int polygonMode, int cullFace, float polygonOffset, boolean backFaceNormalFlip) {
        this(polygonMode, cullFace, polygonOffset, backFaceNormalFlip, 0.0f);
    }

    public PolygonAttributes(int polygonMode, int cullFace, float polygonOffset, boolean backFaceNormalFlip, float polygonOffsetFactor) {
        if (polygonMode < 0 || polygonMode > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes0"));
        }
        if (cullFace < 0 || cullFace > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes12"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((PolygonAttributesRetained)this.retained).initPolygonMode(polygonMode);
        ((PolygonAttributesRetained)this.retained).initCullFace(cullFace);
        ((PolygonAttributesRetained)this.retained).initPolygonOffset(polygonOffset);
        ((PolygonAttributesRetained)this.retained).initBackFaceNormalFlip(backFaceNormalFlip);
        ((PolygonAttributesRetained)this.retained).initPolygonOffsetFactor(polygonOffsetFactor);
    }

    public void setCullFace(int cullFace) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes2"));
        }
        if (cullFace < 0 || cullFace > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes3"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setCullFace(cullFace);
        } else {
            ((PolygonAttributesRetained)this.retained).initCullFace(cullFace);
        }
    }

    public int getCullFace() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes4"));
        }
        return ((PolygonAttributesRetained)this.retained).getCullFace();
    }

    public void setBackFaceNormalFlip(boolean backFaceNormalFlip) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes5"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setBackFaceNormalFlip(backFaceNormalFlip);
        } else {
            ((PolygonAttributesRetained)this.retained).initBackFaceNormalFlip(backFaceNormalFlip);
        }
    }

    public boolean getBackFaceNormalFlip() {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes6"));
        }
        return ((PolygonAttributesRetained)this.retained).getBackFaceNormalFlip();
    }

    public void setPolygonMode(int polygonMode) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes7"));
        }
        if (polygonMode < 0 || polygonMode > 2) {
            throw new IllegalArgumentException(J3dI18N.getString("PolygonAttributes8"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setPolygonMode(polygonMode);
        } else {
            ((PolygonAttributesRetained)this.retained).initPolygonMode(polygonMode);
        }
    }

    public int getPolygonMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes9"));
        }
        return ((PolygonAttributesRetained)this.retained).getPolygonMode();
    }

    public void setPolygonOffset(float polygonOffset) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes10"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setPolygonOffset(polygonOffset);
        } else {
            ((PolygonAttributesRetained)this.retained).initPolygonOffset(polygonOffset);
        }
    }

    public float getPolygonOffset() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes11"));
        }
        return ((PolygonAttributesRetained)this.retained).getPolygonOffset();
    }

    public void setPolygonOffsetFactor(float polygonOffsetFactor) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes10"));
        }
        if (this.isLive()) {
            ((PolygonAttributesRetained)this.retained).setPolygonOffsetFactor(polygonOffsetFactor);
        } else {
            ((PolygonAttributesRetained)this.retained).initPolygonOffsetFactor(polygonOffsetFactor);
        }
    }

    public float getPolygonOffsetFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PolygonAttributes11"));
        }
        return ((PolygonAttributesRetained)this.retained).getPolygonOffsetFactor();
    }

    @Override
    void createRetained() {
        this.retained = new PolygonAttributesRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        PolygonAttributes pga = new PolygonAttributes();
        pga.duplicateNodeComponent(this);
        return pga;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        PolygonAttributesRetained attr = (PolygonAttributesRetained)originalNodeComponent.retained;
        PolygonAttributesRetained rt = (PolygonAttributesRetained)this.retained;
        rt.initCullFace(attr.getCullFace());
        rt.initBackFaceNormalFlip(attr.getBackFaceNormalFlip());
        rt.initPolygonMode(attr.getPolygonMode());
        rt.initPolygonOffset(attr.getPolygonOffset());
        rt.initPolygonOffsetFactor(attr.getPolygonOffsetFactor());
    }
}

